/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.tamsiree.rxkit.RxDataTool;
import com.tamsiree.rxkit.RxImageTool;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J,\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J<\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007JD\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J<\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007JD\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/tamsiree/rxkit/RxPictureTool;", "", "()V", "imagePickerIntent", "Landroid/content/Intent;", "getImagePickerIntent", "()Landroid/content/Intent;", "openCameraIntent", "getOpenCameraIntent", "getCameraIntent", "saveFileURI", "Landroid/net/Uri;", "getChoosedImage", "Landroid/graphics/Bitmap;", "context", "Landroid/app/Activity;", "data", "getChoosedImagePath", "", "getCropImageIntent", "outputX", "", "outputY", "fromFileURI", "aspectX", "aspectY", "canScale", "", "getTakePictureFile", "Ljava/io/File;", "filePath", "RxKit_release"})
public final class RxPictureTool {
    @NotNull
    public static final RxPictureTool INSTANCE = new RxPictureTool();

    private RxPictureTool() {
    }

    @NotNull
    public final Intent getOpenCameraIntent() {
        return new Intent("android.media.action.IMAGE_CAPTURE");
    }

    @NotNull
    public final Intent getImagePickerIntent() {
        Intent intent = new Intent("android.intent.action.PICK", null);
        Intent intent2 = intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, \"image/*\")");
        return intent2;
    }

    @JvmStatic
    @NotNull
    public static final Intent getImagePickerIntent(int outputX, int outputY, @Nullable Uri fromFileURI, @Nullable Uri saveFileURI) {
        return RxPictureTool.getImagePickerIntent(1, 1, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    @JvmStatic
    @NotNull
    public static final Intent getImagePickerIntent(int aspectX, int aspectY, int outputX, int outputY, @Nullable Uri fromFileURI, @Nullable Uri saveFileURI) {
        return RxPictureTool.getImagePickerIntent(aspectX, aspectY, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    @JvmStatic
    @NotNull
    public static final Intent getImagePickerIntent(int aspectX, int aspectY, int outputX, int outputY, boolean canScale, @Nullable Uri fromFileURI, @Nullable Uri saveFileURI) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setDataAndType(fromFileURI, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", aspectX <= 0 ? 1 : aspectX);
        intent.putExtra("aspectY", aspectY <= 0 ? 1 : aspectY);
        intent.putExtra("outputX", outputX);
        intent.putExtra("outputY", outputY);
        intent.putExtra("scale", canScale);
        intent.putExtra("scaleUpIfNeeded", true);
        intent.putExtra("return-data", false);
        intent.putExtra("output", (Parcelable)saveFileURI);
        intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        Intent intent2 = intent.putExtra("noFaceDetection", true);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent.putExtra(\"noFaceDetection\", true)");
        return intent2;
    }

    @JvmStatic
    @NotNull
    public static final Intent getCameraIntent(@Nullable Uri saveFileURI) {
        Intent mIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        Intent intent = mIntent.putExtra("output", (Parcelable)saveFileURI);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"mIntent.putExtra(MediaStore.EXTRA_OUTPUT, saveFileURI)");
        return intent;
    }

    @JvmStatic
    @NotNull
    public static final Intent getCropImageIntent(int outputX, int outputY, @Nullable Uri fromFileURI, @Nullable Uri saveFileURI) {
        return RxPictureTool.getCropImageIntent(1, 1, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    @JvmStatic
    @NotNull
    public static final Intent getCropImageIntent(int aspectX, int aspectY, int outputX, int outputY, @Nullable Uri fromFileURI, @Nullable Uri saveFileURI) {
        return RxPictureTool.getCropImageIntent(aspectX, aspectY, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    @JvmStatic
    @NotNull
    public static final Intent getCropImageIntent(int aspectX, int aspectY, int outputX, int outputY, boolean canScale, @Nullable Uri fromFileURI, @Nullable Uri saveFileURI) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(fromFileURI, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", aspectX <= 0 ? 1 : aspectX);
        intent.putExtra("aspectY", aspectY <= 0 ? 1 : aspectY);
        intent.putExtra("outputX", outputX);
        intent.putExtra("outputY", outputY);
        intent.putExtra("scale", canScale);
        intent.putExtra("scaleUpIfNeeded", true);
        intent.putExtra("return-data", false);
        intent.putExtra("output", (Parcelable)saveFileURI);
        intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        intent.putExtra("noFaceDetection", true);
        return intent;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getChoosedImage(@NotNull Activity context, @Nullable Intent data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (data == null) {
            return null;
        }
        Bitmap bm = null;
        ContentResolver cr = context.getContentResolver();
        Uri originalUri = data.getData();
        try {
            bm = MediaStore.Images.Media.getBitmap((ContentResolver)cr, (Uri)originalUri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String getChoosedImagePath(@NotNull Activity context, @Nullable Intent data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (data == null) {
            return null;
        }
        String path = "";
        ContentResolver resolver = context.getContentResolver();
        String[] stringArray = data.getData();
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = stringArray;
        String[] originalUri = stringArray2;
        String[] projection = stringArray = new String[]{"_data"};
        Cursor cursor = resolver.query((Uri)originalUri, projection, null, null, null);
        if (cursor != null) {
            try {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                String string = cursor.getString(column_index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(column_index)");
                path = string;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (!cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return RxDataTool.Companion.isNullString(path) ? originalUri.getPath() : null;
    }

    @JvmStatic
    @Nullable
    public static final File getTakePictureFile(@Nullable Intent data, @Nullable String filePath) {
        Bundle bundle;
        if (data == null) {
            return null;
        }
        Bundle bundle2 = data.getExtras();
        if (bundle2 == null) {
            return null;
        }
        Bundle extras = bundle = bundle2;
        Bitmap photo = (Bitmap)extras.getParcelable("data");
        File file = new File(filePath);
        Intrinsics.checkNotNull((Object)photo);
        return RxImageTool.save$default(photo, file, Bitmap.CompressFormat.JPEG, false, 8, null) ? file : null;
    }
}

