/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.widget.Toast;
import com.tamsiree.rxkit.view.RxToast;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\"\u001a\u00020\u0017H\u0007J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/tamsiree/rxkit/RxNetTool;", "", "()V", "NETWORK_2G", "", "NETWORK_3G", "NETWORK_4G", "NETWORK_NO", "NETWORK_TYPE_GSM", "NETWORK_TYPE_IWLAN", "NETWORK_TYPE_TD_SCDMA", "NETWORK_UNKNOWN", "NETWORK_WIFI", "getActiveNetworkInfo", "Landroid/net/NetworkInfo;", "context", "Landroid/content/Context;", "getNetWorkType", "getNetWorkTypeName", "", "getNetworkOperatorName", "getPhoneType", "is3rd", "", "is4G", "isAvailable", "isConnected", "isGpsEnabled", "isNetworkAvailable", "isWifi", "isWifiConnected", "isWifiEnabled", "openWirelessSettings", "", "ping", "ip", "RxKit_release"})
public final class RxNetTool {
    @NotNull
    public static final RxNetTool INSTANCE = new RxNetTool();
    public static final int NETWORK_NO = -1;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_UNKNOWN = 5;
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;

    private RxNetTool() {
    }

    @JvmStatic
    public static final int getNetWorkType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo ni = cm.getActiveNetworkInfo();
        int netType = -1;
        if (ni != null && ni.isConnectedOrConnecting()) {
            int n = ni.getType();
            switch (n) {
                case 1: {
                    netType = 1;
                    RxToast.success("\u5207\u6362\u5230wifi\u73af\u5883\u4e0b");
                    break;
                }
                case 0: {
                    boolean bl;
                    int n2 = ni.getSubtype();
                    if (((((n2 == 16 ? true : n2 == 1) ? true : n2 == 4) ? true : n2 == 2) ? true : n2 == 7) ? true : n2 == 11) {
                        netType = 2;
                        RxToast.info("\u5207\u6362\u52302G\u73af\u5883\u4e0b");
                        break;
                    }
                    switch (n2) {
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            bl = true;
                            break;
                        }
                        default: {
                            bl = n2 == 17;
                        }
                    }
                    if (bl) {
                        netType = 3;
                        RxToast.info("\u5207\u6362\u52303G\u73af\u5883\u4e0b");
                        break;
                    }
                    boolean bl2 = n2 == 13 ? true : n2 == 18;
                    if (bl2) {
                        netType = 4;
                        RxToast.info("\u5207\u6362\u52304G\u73af\u5883\u4e0b");
                        break;
                    }
                    String subtypeName = ni.getSubtypeName();
                    netType = StringsKt.equals((String)subtypeName, (String)"TD-SCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"WCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"CDMA2000", (boolean)true) ? 3 : 5;
                    RxToast.normal("\u672a\u77e5\u7f51\u7edc");
                    break;
                }
                default: {
                    netType = 5;
                    RxToast.normal("\u672a\u77e5\u7f51\u7edc");
                    break;
                }
            }
        } else {
            netType = -1;
            Toast toast = RxToast.error(context, "\u5f53\u524d\u65e0\u7f51\u7edc\u8fde\u63a5");
            if (toast != null) {
                toast.show();
            }
        }
        return netType;
    }

    @JvmStatic
    @NotNull
    public static final String getNetWorkTypeName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int n = RxNetTool.getNetWorkType(context);
        return n == 1 ? "NETWORK_WIFI" : (n == 4 ? "NETWORK_4G" : (n == 3 ? "NETWORK_3G" : (n == 2 ? "NETWORK_2G" : (n == -1 ? "NETWORK_NO" : "NETWORK_UNKNOWN"))));
    }

    @JvmStatic
    public static final boolean isNetworkAvailable(@NotNull Context context) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo[] info = cm.getAllNetworkInfo();
        if (info != null && (n2 = 0) <= (n = info.length + -1)) {
            do {
                int i;
                if (info[i = n2++].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            } while (n2 <= n);
        }
        return false;
    }

    @JvmStatic
    public static final boolean isAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NetworkInfo info = INSTANCE.getActiveNetworkInfo(context);
        return info != null && info.isAvailable();
    }

    @JvmStatic
    public static final boolean isConnected(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NetworkInfo info = INSTANCE.getActiveNetworkInfo(context);
        return info != null && info.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean ping() {
        String result;
        block7: {
            boolean bl;
            result = null;
            String ip = "www.baidu.com";
            Process p = Runtime.getRuntime().exec(Intrinsics.stringPlus((String)"ping -c 3 -w 100 ", (Object)ip));
            InputStream input = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            StringBuffer stringBuffer = new StringBuffer();
            String content = null;
            content = "";
            while (true) {
                String string = in.readLine();
                bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                content = it;
                if (string == null) break;
                stringBuffer.append(content);
            }
            int status = p.waitFor();
            if (status != 0) break block7;
            result = "success";
            bl = true;
            return bl;
        }
        try {
            result = "failed";
        }
        catch (IOException e) {
            result = "IOException";
        }
        catch (InterruptedException e) {
            result = "InterruptedException";
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean ping(@NotNull String ip) {
        String result;
        block7: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            result = null;
            Process p = Runtime.getRuntime().exec(Intrinsics.stringPlus((String)"ping -c 3 -w 100 ", (Object)ip));
            InputStream input = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            StringBuffer stringBuffer = new StringBuffer();
            String content = null;
            content = "";
            while (true) {
                String string = in.readLine();
                bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                content = it;
                if (string == null) break;
                stringBuffer.append(content);
            }
            int status = p.waitFor();
            if (status != 0) break block7;
            result = "success";
            bl = true;
            return bl;
        }
        try {
            result = "failed";
        }
        catch (IOException e) {
            result = "IOException";
        }
        catch (InterruptedException e) {
            result = "InterruptedException";
        }
        return false;
    }

    @JvmStatic
    public static final boolean isWifiEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager mgrConn = (ConnectivityManager)object;
        Object object2 = context.getSystemService("phone");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager mgrTel = (TelephonyManager)object2;
        return mgrConn.getActiveNetworkInfo() != null && mgrConn.getActiveNetworkInfo().getState() == NetworkInfo.State.CONNECTED || mgrTel.getNetworkType() == 3;
    }

    @JvmStatic
    public static final boolean isWifi(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NetworkInfo networkINfo = INSTANCE.getActiveNetworkInfo(context);
        return networkINfo != null && networkINfo.getType() == 1;
    }

    @JvmStatic
    public static final boolean isWifiConnected(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        return cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().getType() == 1;
    }

    @JvmStatic
    public static final boolean is3rd(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo networkINfo = cm.getActiveNetworkInfo();
        return networkINfo != null && networkINfo.getType() == 0;
    }

    @JvmStatic
    public static final boolean is4G(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NetworkInfo info = INSTANCE.getActiveNetworkInfo(context);
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    @JvmStatic
    public static final boolean isGpsEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager lm = (LocationManager)object;
        List accessibleProviders = lm.getProviders(true);
        return accessibleProviders != null && accessibleProviders.size() > 0;
    }

    @JvmStatic
    public static final void openWirelessSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT > 10) {
            context.startActivity(new Intent("android.settings.SETTINGS"));
        } else {
            context.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
        }
    }

    private final NetworkInfo getActiveNetworkInfo(Context context) {
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        object = cm.getActiveNetworkInfo();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cm.activeNetworkInfo");
        return object;
    }

    @JvmStatic
    @Nullable
    public static final String getNetworkOperatorName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getNetworkOperatorName();
    }

    @JvmStatic
    public static final int getPhoneType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        TelephonyManager tm = (TelephonyManager)object;
        return tm.getPhoneType();
    }
}

