/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.location.Location;
import android.media.ExifInterface;
import com.orhanobut.logger.Logger;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/tamsiree/rxkit/RxExifTool;", "", "()V", "gpsInfoConvert", "", "gpsInfo", "", "writeLatLonIntoJpeg", "", "picPath", "dLat", "dLon", "RxKit_release"})
public final class RxExifTool {
    @NotNull
    public static final RxExifTool INSTANCE = new RxExifTool();

    private RxExifTool() {
    }

    @JvmStatic
    public static final void writeLatLonIntoJpeg(@NotNull String picPath, double dLat, double dLon) {
        Intrinsics.checkNotNullParameter((Object)picPath, (String)"picPath");
        File file = new File(picPath);
        if (file.exists()) {
            try {
                ExifInterface exif = new ExifInterface(picPath);
                String tagLat = exif.getAttribute("GPSLatitude");
                String tagLon = exif.getAttribute("GPSLongitude");
                if (tagLat == null && tagLon == null) {
                    exif.setAttribute("GPSLatitude", INSTANCE.gpsInfoConvert(dLat));
                    exif.setAttribute("GPSLatitudeRef", dLat > 0.0 ? "N" : "S");
                    exif.setAttribute("GPSLongitude", INSTANCE.gpsInfoConvert(dLon));
                    exif.setAttribute("GPSLongitudeRef", dLon > 0.0 ? "E" : "W");
                    exif.saveAttributes();
                }
                exif.saveAttributes();
                Logger.d((String)StringsKt.trimIndent((String)("\n    " + exif.getAttribute("GPSLatitude") + "\n    " + exif.getAttribute("GPSLongitude") + "\n    " + exif.getAttribute("GPSProcessingMethod") + "\n    " + exif.getAttribute("ImageLength") + "\n    " + exif.getAttribute("ImageWidth") + "\n    ")), (Object[])new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final String gpsInfoConvert(double gpsInfo) {
        double gpsInfo2 = gpsInfo;
        gpsInfo2 = Math.abs(gpsInfo2);
        String dms = Location.convert((double)gpsInfo2, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)dms, (String)"dms");
        String[] stringArray = new String[]{":"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)dms, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] splits = stringArray2;
        String[] $i$f$toTypedArray22 = new String[]{"\\."};
        Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)splits[2], (String[])$i$f$toTypedArray22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] secnds = stringArray3;
        String seconds = null;
        seconds = secnds.length == 0 ? splits[2] : secnds[0];
        return splits[0] + "/1," + splits[1] + "/1," + seconds + "/1";
    }
}

