/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/tamsiree/rxkit/RxClipboardTool;", "", "()V", "copyIntent", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "copyText", "text", "", "copyUri", "uri", "Landroid/net/Uri;", "getIntent", "getText", "getUri", "RxKit_release"})
public final class RxClipboardTool {
    public static final RxClipboardTool INSTANCE;

    @JvmStatic
    public static final void copyText(@NotNull Context context, @Nullable CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"text", (CharSequence)text));
    }

    @JvmStatic
    @Nullable
    public static final CharSequence getText(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = clipboard.getPrimaryClip();
        return clip != null && clip.getItemCount() > 0 ? clip.getItemAt(0).coerceToText(context) : null;
    }

    @JvmStatic
    public static final void copyUri(@NotNull Context context, @Nullable Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        clipboard.setPrimaryClip(ClipData.newUri((ContentResolver)context.getContentResolver(), (CharSequence)"uri", (Uri)uri));
    }

    @JvmStatic
    @Nullable
    public static final Uri getUri(@NotNull Context context) {
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            ClipData.Item item = clip.getItemAt(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"clip.getItemAt(0)");
            uri = item.getUri();
        } else {
            uri = null;
        }
        return uri;
    }

    @JvmStatic
    public static final void copyIntent(@NotNull Context context, @Nullable Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        clipboard.setPrimaryClip(ClipData.newIntent((CharSequence)"intent", (Intent)intent));
    }

    @JvmStatic
    @Nullable
    public static final Intent getIntent(@NotNull Context context) {
        Intent intent;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            ClipData.Item item = clip.getItemAt(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"clip.getItemAt(0)");
            intent = item.getIntent();
        } else {
            intent = null;
        }
        return intent;
    }

    private RxClipboardTool() {
    }

    static {
        RxClipboardTool rxClipboardTool;
        INSTANCE = rxClipboardTool = new RxClipboardTool();
    }
}

