/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.photomagic;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import com.tamsiree.rxkit.photomagic.Checker;
import com.tamsiree.rxkit.photomagic.Engine;
import com.tamsiree.rxkit.photomagic.OnCompressListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0083\u0002J\u0019\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0083\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/tamsiree/rxkit/photomagic/RxMagic;", "Landroid/os/Handler$Callback;", "builder", "Lcom/tamsiree/rxkit/photomagic/RxMagic$Builder;", "(Lcom/tamsiree/rxkit/photomagic/RxMagic$Builder;)V", "mCompressListener", "Lcom/tamsiree/rxkit/photomagic/OnCompressListener;", "mHandler", "Landroid/os/Handler;", "mLeastCompressSize", "", "mPaths", "", "", "mTargetDir", "get", "", "Ljava/io/File;", "context", "Landroid/content/Context;", "path", "getImageCacheDir", "cacheName", "getImageCacheFile", "suffix", "handleMessage", "", "msg", "Landroid/os/Message;", "launch", "", "Builder", "Companion", "RxKit_release"})
public final class RxMagic
implements Handler.Callback {
    private String mTargetDir;
    private final List<String> mPaths;
    private final int mLeastCompressSize;
    private final OnCompressListener mCompressListener;
    private final Handler mHandler;
    private static final String TAG = "RxMagic";
    private static final String DEFAULT_DISK_CACHE_DIR = "rxmagic_disk_cache";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    public static final Companion Companion = new Companion(null);

    private final File getImageCacheFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            File file = this.getImageCacheDir(context);
            if (file == null) {
                Intrinsics.throwNpe();
            }
            this.mTargetDir = file.getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * (double)1000) + (TextUtils.isEmpty((CharSequence)suffix) ? ".jpg" : suffix);
        return new File(cacheBuilder);
    }

    private final File getImageCacheDir(Context context) {
        return this.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    private final File getImageCacheDir(Context context, String cacheName) {
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            return !result.mkdirs() && (!result.exists() || !result.isDirectory()) ? null : result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    @UiThread
    private final void launch(Context context) {
        if (this.mPaths == null || this.mPaths.size() == 0 && this.mCompressListener != null) {
            OnCompressListener onCompressListener = this.mCompressListener;
            if (onCompressListener == null) {
                Intrinsics.throwNpe();
            }
            onCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        List<String> list = this.mPaths;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String path = iterator.next();
            if (Checker.isImage(path)) {
                AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(this, path, context){
                    final /* synthetic */ RxMagic this$0;
                    final /* synthetic */ String $path;
                    final /* synthetic */ Context $context;

                    public final void run() {
                        try {
                            RxMagic.access$getMHandler$p(this.this$0).sendMessage(RxMagic.access$getMHandler$p(this.this$0).obtainMessage(1));
                            File result = Checker.isNeedCompress(RxMagic.access$getMLeastCompressSize$p(this.this$0), this.$path) ? new Engine(this.$path, RxMagic.access$getImageCacheFile(this.this$0, this.$context, Checker.checkSuffix(this.$path))).compress() : new File(this.$path);
                            RxMagic.access$getMHandler$p(this.this$0).sendMessage(RxMagic.access$getMHandler$p(this.this$0).obtainMessage(0, (Object)result));
                        }
                        catch (IOException e) {
                            RxMagic.access$getMHandler$p(this.this$0).sendMessage(RxMagic.access$getMHandler$p(this.this$0).obtainMessage(2, (Object)e));
                        }
                    }
                    {
                        this.this$0 = rxMagic;
                        this.$path = string2;
                        this.$context = context;
                    }
                });
            } else {
                OnCompressListener onCompressListener = this.mCompressListener;
                if (onCompressListener == null) {
                    Intrinsics.throwNpe();
                }
                onCompressListener.onError(new IllegalArgumentException("can not read the path : " + path));
            }
            iterator.remove();
        }
    }

    @WorkerThread
    private final File get(String path, Context context) throws IOException {
        return new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path))).compress();
    }

    @WorkerThread
    private final List<File> get(Context context) throws IOException {
        List results = new ArrayList();
        List<String> list = this.mPaths;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String path = iterator.next();
            if (Checker.isImage(path)) {
                results.add(new Engine(path, this.getImageCacheFile(context, Checker.checkSuffix(path))).compress());
            }
            iterator.remove();
        }
        return results;
    }

    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (this.mCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mCompressListener.onStart();
                break;
            }
            case 0: {
                Object object = msg.obj;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.File");
                }
                this.mCompressListener.onSuccess((File)object);
                break;
            }
            case 2: {
                Object object = msg.obj;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                }
                this.mCompressListener.onError((Throwable)object);
                break;
            }
        }
        return false;
    }

    private RxMagic(Builder builder) {
        this.mPaths = builder.getMPaths$RxKit_release();
        this.mTargetDir = builder.getMTargetDir$RxKit_release();
        this.mCompressListener = builder.getMCompressListener$RxKit_release();
        this.mLeastCompressSize = builder.getMLeastCompressSize$RxKit_release();
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public /* synthetic */ RxMagic(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    public static final /* synthetic */ Handler access$getMHandler$p(RxMagic $this) {
        return $this.mHandler;
    }

    public static final /* synthetic */ int access$getMLeastCompressSize$p(RxMagic $this) {
        return $this.mLeastCompressSize;
    }

    public static final /* synthetic */ File access$getImageCacheFile(RxMagic $this, Context context, String suffix) {
        return $this.getImageCacheFile(context, suffix);
    }

    @JvmStatic
    @NotNull
    public static final Builder createBuilder(@NotNull Context context) {
        return Companion.createBuilder(context);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0011\u0010\u001d\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0086\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\fJ\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001fJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0013J\u0016\u0010%\u001a\u00020\u00002\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001eJ\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\fJ\u0010\u0010+\u001a\u00020\u00002\b\u0010,\u001a\u0004\u0018\u00010\u0006J\u0010\u0010-\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006/"}, d2={"Lcom/tamsiree/rxkit/photomagic/RxMagic$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCompressListener", "Lcom/tamsiree/rxkit/photomagic/OnCompressListener;", "getMCompressListener$RxKit_release", "()Lcom/tamsiree/rxkit/photomagic/OnCompressListener;", "setMCompressListener$RxKit_release", "(Lcom/tamsiree/rxkit/photomagic/OnCompressListener;)V", "mLeastCompressSize", "", "getMLeastCompressSize$RxKit_release", "()I", "setMLeastCompressSize$RxKit_release", "(I)V", "mPaths", "", "", "getMPaths$RxKit_release", "()Ljava/util/List;", "mTargetDir", "getMTargetDir$RxKit_release", "()Ljava/lang/String;", "setMTargetDir$RxKit_release", "(Ljava/lang/String;)V", "build", "Lcom/tamsiree/rxkit/photomagic/RxMagic;", "get", "", "Ljava/io/File;", "path", "ignoreBy", "size", "launch", "", "load", "file", "string", "list", "putGear", "gear", "setCompressListener", "listener", "setTargetDir", "targetDir", "RxKit_release"})
    public static final class Builder {
        @Nullable
        private String mTargetDir;
        @NotNull
        private final List<String> mPaths;
        private int mLeastCompressSize;
        @Nullable
        private OnCompressListener mCompressListener;
        private final Context context;

        @Nullable
        public final String getMTargetDir$RxKit_release() {
            return this.mTargetDir;
        }

        public final void setMTargetDir$RxKit_release(@Nullable String string2) {
            this.mTargetDir = string2;
        }

        @NotNull
        public final List<String> getMPaths$RxKit_release() {
            return this.mPaths;
        }

        public final int getMLeastCompressSize$RxKit_release() {
            return this.mLeastCompressSize;
        }

        public final void setMLeastCompressSize$RxKit_release(int n) {
            this.mLeastCompressSize = n;
        }

        @Nullable
        public final OnCompressListener getMCompressListener$RxKit_release() {
            return this.mCompressListener;
        }

        public final void setMCompressListener$RxKit_release(@Nullable OnCompressListener onCompressListener) {
            this.mCompressListener = onCompressListener;
        }

        private final RxMagic build() {
            return new RxMagic(this, null);
        }

        @NotNull
        public final Builder load(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String string2 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.absolutePath");
            this.mPaths.add(string2);
            return this;
        }

        @NotNull
        public final Builder load(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"string");
            this.mPaths.add(string2);
            return this;
        }

        @NotNull
        public final Builder load(@Nullable List<String> list) {
            List<String> list2 = list;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            this.mPaths.addAll((Collection<String>)list2);
            return this;
        }

        @NotNull
        public final Builder putGear(int gear) {
            return this;
        }

        @NotNull
        public final Builder setCompressListener(@Nullable OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        @NotNull
        public final Builder setTargetDir(@Nullable String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        @NotNull
        public final Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public final void launch() {
            this.build().launch(this.context);
        }

        @NotNull
        public final File get(@NotNull String path) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return this.build().get(path, this.context);
        }

        @NotNull
        public final List<File> get() throws IOException {
            return this.build().get(this.context);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.mLeastCompressSize = 100;
            this.mPaths = new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/tamsiree/rxkit/photomagic/RxMagic$Companion;", "", "()V", "DEFAULT_DISK_CACHE_DIR", "", "MSG_COMPRESS_ERROR", "", "MSG_COMPRESS_START", "MSG_COMPRESS_SUCCESS", "TAG", "createBuilder", "Lcom/tamsiree/rxkit/photomagic/RxMagic$Builder;", "context", "Landroid/content/Context;", "RxKit_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder createBuilder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return new Builder(context);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

