/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.tamsiree.rxkit.RxDataTool;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/tamsiree/rxkit/RxProcessTool;", "", "()V", "getAllBackgroundProcesses", "", "", "context", "Landroid/content/Context;", "getForegroundProcessName", "killAllBackgroundProcesses", "", "killBackgroundProcesses", "", "packageName", "RxKit_release"})
public final class RxProcessTool {
    public static final RxProcessTool INSTANCE;

    @JvmStatic
    @Nullable
    public static final String getForegroundProcessName(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager manager = (ActivityManager)object;
        List infos = manager.getRunningAppProcesses();
        if (infos != null && infos.size() != 0) {
            for (ActivityManager.RunningAppProcessInfo info : infos) {
                if (info.importance != 100) continue;
                return info.processName;
            }
        }
        if (Build.VERSION.SDK_INT > 21) {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            List list = packageManager.queryIntentActivities(intent, 65536);
            boolean bl = false;
            System.out.println(list);
            if (list.size() > 0) {
                try {
                    ApplicationInfo info = packageManager.getApplicationInfo(context.getPackageName(), 0);
                    Object object2 = context.getSystemService("appops");
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.AppOpsManager");
                    }
                    AppOpsManager aom = (AppOpsManager)object2;
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        context.startActivity(intent);
                    }
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        Log.d((String)"getForegroundApp", (String)"\u6ca1\u6709\u6253\u5f00\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
                        return null;
                    }
                    Object object3 = context.getSystemService("usagestats");
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.usage.UsageStatsManager");
                    }
                    UsageStatsManager usageStatsManager = (UsageStatsManager)object3;
                    long endTime = System.currentTimeMillis();
                    long beginTime = endTime - (long)604800000;
                    List usageStatses = usageStatsManager.queryUsageStats(4, beginTime, endTime);
                    if (usageStatses == null || usageStatses.isEmpty()) {
                        return null;
                    }
                    UsageStats recentStats = null;
                    for (UsageStats usageStats : usageStatses) {
                        if (recentStats != null) {
                            UsageStats usageStats2 = usageStats;
                            Intrinsics.checkExpressionValueIsNotNull((Object)usageStats2, (String)"usageStats");
                            if (usageStats2.getLastTimeUsed() <= recentStats.getLastTimeUsed()) continue;
                        }
                        recentStats = usageStats;
                    }
                    UsageStats usageStats = recentStats;
                    return usageStats != null ? usageStats.getPackageName() : null;
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                Log.d((String)"getForegroundApp", (String)"\u65e0\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
            }
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> getAllBackgroundProcesses(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        List infos = am.getRunningAppProcesses();
        Collection set = new HashSet();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            Collections.addAll(set, Arrays.copyOf(info.pkgList, info.pkgList.length));
        }
        return set;
    }

    @JvmStatic
    @NotNull
    public static final Set<String> killAllBackgroundProcesses(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        List infos = am.getRunningAppProcesses();
        Set set = new HashSet();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            for (String pkg : info.pkgList) {
                am.killBackgroundProcesses(pkg);
                String string2 = pkg;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pkg");
                set.add(string2);
            }
        }
        infos = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            for (String pkg : info.pkgList) {
                set.remove(pkg);
            }
        }
        return set;
    }

    @JvmStatic
    public static final boolean killBackgroundProcesses(@NotNull Context context, @Nullable String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (RxDataTool.Companion.isNullString(packageName)) {
            return false;
        }
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        List infos = am.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (!Arrays.asList(Arrays.copyOf(info.pkgList, info.pkgList.length)).contains(packageName)) continue;
            am.killBackgroundProcesses(packageName);
        }
        infos = am.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (!Arrays.asList(Arrays.copyOf(info.pkgList, info.pkgList.length)).contains(packageName)) continue;
            return false;
        }
        return true;
    }

    private RxProcessTool() {
    }

    static {
        RxProcessTool rxProcessTool;
        INSTANCE = rxProcessTool = new RxProcessTool();
    }
}

