/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import com.tamsiree.rxkit.interfaces.OnDoIntListener;

public class RxAnimationTool {
    public static void start(Animator animator) {
        if (animator != null && !animator.isStarted()) {
            animator.start();
        }
    }

    public static void stop(Animator animator) {
        if (animator != null && !animator.isRunning()) {
            animator.end();
        }
    }

    public static boolean isRunning(ValueAnimator animator) {
        return animator != null && animator.isRunning();
    }

    public static boolean isStarted(ValueAnimator animator) {
        return animator != null && animator.isStarted();
    }

    public static void animationColorGradient(int beforeColor, int afterColor, final OnDoIntListener listener) {
        ValueAnimator valueAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{beforeColor, afterColor}).setDuration(3000L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                listener.doSomething((Integer)animation.getAnimatedValue());
            }
        });
        valueAnimator.start();
    }

    public static void cardFilpAnimation(final View beforeView, final View afterView) {
        AccelerateInterpolator accelerator = new AccelerateInterpolator();
        DecelerateInterpolator decelerator = new DecelerateInterpolator();
        ObjectAnimator invisToVis = null;
        ObjectAnimator visToInvis = null;
        if (beforeView.getVisibility() == 8) {
            invisToVis = ObjectAnimator.ofFloat((Object)beforeView, (String)"rotationY", (float[])new float[]{-90.0f, 0.0f});
            visToInvis = ObjectAnimator.ofFloat((Object)afterView, (String)"rotationY", (float[])new float[]{0.0f, 90.0f});
        } else if (afterView.getVisibility() == 8) {
            invisToVis = ObjectAnimator.ofFloat((Object)afterView, (String)"rotationY", (float[])new float[]{-90.0f, 0.0f});
            visToInvis = ObjectAnimator.ofFloat((Object)beforeView, (String)"rotationY", (float[])new float[]{0.0f, 90.0f});
        }
        visToInvis.setDuration(250L);
        visToInvis.setInterpolator((TimeInterpolator)accelerator);
        invisToVis.setDuration(250L);
        invisToVis.setInterpolator((TimeInterpolator)decelerator);
        final ObjectAnimator finalInvisToVis = invisToVis;
        final ObjectAnimator finalVisToInvis = visToInvis;
        visToInvis.addListener(new Animator.AnimatorListener(){

            public void onAnimationEnd(Animator arg0) {
                if (beforeView.getVisibility() == 8) {
                    afterView.setVisibility(8);
                    finalInvisToVis.start();
                    beforeView.setVisibility(0);
                } else {
                    afterView.setVisibility(8);
                    finalVisToInvis.start();
                    beforeView.setVisibility(0);
                }
            }

            public void onAnimationCancel(Animator arg0) {
            }

            public void onAnimationRepeat(Animator arg0) {
            }

            public void onAnimationStart(Animator arg0) {
            }
        });
        visToInvis.start();
    }

    public static void zoomIn(View view, float scale, float dist) {
        view.setPivotY((float)view.getHeight());
        view.setPivotX((float)(view.getWidth() / 2));
        AnimatorSet mAnimatorSet = new AnimatorSet();
        ObjectAnimator mAnimatorScaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{1.0f, scale});
        ObjectAnimator mAnimatorScaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{1.0f, scale});
        ObjectAnimator mAnimatorTranslateY = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{0.0f, -dist});
        mAnimatorSet.play((Animator)mAnimatorTranslateY).with((Animator)mAnimatorScaleX);
        mAnimatorSet.play((Animator)mAnimatorScaleX).with((Animator)mAnimatorScaleY);
        mAnimatorSet.setDuration(300L);
        mAnimatorSet.start();
    }

    public static void zoomOut(View view, float scale) {
        view.setPivotY((float)view.getHeight());
        view.setPivotX((float)(view.getWidth() / 2));
        AnimatorSet mAnimatorSet = new AnimatorSet();
        ObjectAnimator mAnimatorScaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{scale, 1.0f});
        ObjectAnimator mAnimatorScaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{scale, 1.0f});
        ObjectAnimator mAnimatorTranslateY = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{view.getTranslationY(), 0.0f});
        mAnimatorSet.play((Animator)mAnimatorTranslateY).with((Animator)mAnimatorScaleX);
        mAnimatorSet.play((Animator)mAnimatorScaleX).with((Animator)mAnimatorScaleY);
        mAnimatorSet.setDuration(300L);
        mAnimatorSet.start();
    }

    public static void ScaleUpDowm(View view) {
        ScaleAnimation animation = new ScaleAnimation(1.0f, 1.0f, 0.0f, 1.0f);
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        animation.setInterpolator((Interpolator)new LinearInterpolator());
        animation.setDuration(1200L);
        view.startAnimation((Animation)animation);
    }

    public static void animateHeight(int start, int end, final View view) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{start, end});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.height = value;
                view.setLayoutParams(layoutParams);
            }
        });
        valueAnimator.start();
    }

    public static ObjectAnimator popup(View view, long duration) {
        view.setAlpha(0.0f);
        view.setVisibility(0);
        ObjectAnimator popup = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.0f, 1.0f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.0f, 1.0f})});
        popup.setDuration(duration);
        popup.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        return popup;
    }

    public static ObjectAnimator popout(final View view, long duration, final AnimatorListenerAdapter animatorListenerAdapter) {
        ObjectAnimator popout = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.0f}), PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.0f})});
        popout.setDuration(duration);
        popout.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.setVisibility(8);
                if (animatorListenerAdapter != null) {
                    animatorListenerAdapter.onAnimationEnd(animation);
                }
            }
        });
        popout.setInterpolator((TimeInterpolator)new AnticipateOvershootInterpolator());
        return popout;
    }

    public static RotateAnimation initRotateAnimation(long duration, int fromAngle, int toAngle, boolean isFillAfter, int repeatCount) {
        RotateAnimation mLoadingRotateAnimation = new RotateAnimation((float)fromAngle, (float)toAngle, 1, 0.5f, 1, 0.5f);
        LinearInterpolator lirInterpolator = new LinearInterpolator();
        mLoadingRotateAnimation.setInterpolator((Interpolator)lirInterpolator);
        mLoadingRotateAnimation.setDuration(duration);
        mLoadingRotateAnimation.setFillAfter(isFillAfter);
        mLoadingRotateAnimation.setRepeatCount(repeatCount);
        mLoadingRotateAnimation.setRepeatMode(1);
        return mLoadingRotateAnimation;
    }

    public static RotateAnimation initRotateAnimation(boolean isClockWise, long duration, boolean isFillAfter, int repeatCount) {
        int endAngle = isClockWise ? 360 : -360;
        RotateAnimation mLoadingRotateAnimation = new RotateAnimation(0.0f, (float)endAngle, 1, 0.5f, 1, 0.5f);
        LinearInterpolator lirInterpolator = new LinearInterpolator();
        mLoadingRotateAnimation.setInterpolator((Interpolator)lirInterpolator);
        mLoadingRotateAnimation.setDuration(duration);
        mLoadingRotateAnimation.setFillAfter(isFillAfter);
        mLoadingRotateAnimation.setRepeatCount(repeatCount);
        mLoadingRotateAnimation.setRepeatMode(1);
        return mLoadingRotateAnimation;
    }

    public static AnimationDrawable initAnimationDrawable(Context context, int[] drawableIds, int durationTime, boolean isOneShot) {
        AnimationDrawable mAnimationDrawable = new AnimationDrawable();
        for (int i = 0; i < drawableIds.length; ++i) {
            int id2 = drawableIds[i];
            mAnimationDrawable.addFrame(context.getResources().getDrawable(id2), durationTime);
        }
        mAnimationDrawable.setOneShot(isOneShot);
        return mAnimationDrawable;
    }

    public static Animation initAlphaAnimtion(Context context, float fromAlpha, float toAlpha, long duration) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(fromAlpha, toAlpha);
        alphaAnimation.setDuration(duration);
        return alphaAnimation;
    }

    public static void startSwitchBackgroundAnim(ImageView view, Bitmap bitmap) {
        Object oldBitmapDrawable;
        Drawable oldDrawable = view.getDrawable();
        TransitionDrawable oldTransitionDrawable = null;
        if (oldDrawable instanceof TransitionDrawable) {
            oldTransitionDrawable = (TransitionDrawable)oldDrawable;
            oldBitmapDrawable = oldTransitionDrawable.findDrawableByLayerId(oldTransitionDrawable.getId(1));
        } else {
            oldBitmapDrawable = oldDrawable instanceof BitmapDrawable ? oldDrawable : new ColorDrawable(-4013374);
        }
        if (oldTransitionDrawable == null) {
            oldTransitionDrawable = new TransitionDrawable(new Drawable[]{oldBitmapDrawable, new BitmapDrawable(bitmap)});
            oldTransitionDrawable.setId(0, 0);
            oldTransitionDrawable.setId(1, 1);
            oldTransitionDrawable.setCrossFadeEnabled(true);
            view.setImageDrawable((Drawable)oldTransitionDrawable);
        } else {
            oldTransitionDrawable.setDrawableByLayerId(oldTransitionDrawable.getId(0), oldBitmapDrawable);
            oldTransitionDrawable.setDrawableByLayerId(oldTransitionDrawable.getId(1), (Drawable)new BitmapDrawable(bitmap));
        }
        oldTransitionDrawable.startTransition(1000);
    }
}

