/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.module.photomagic;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.tamsiree.rxkit.module.photomagic.Checker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class Engine {
    private ExifInterface srcExif;
    private String srcImg;
    private File tagImg;
    private int srcWidth;
    private int srcHeight;

    Engine(String srcImg, File tagImg) throws IOException {
        if (Checker.isJPG(srcImg)) {
            this.srcExif = new ExifInterface(srcImg);
        }
        this.tagImg = tagImg;
        this.srcImg = srcImg;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)srcImg, (BitmapFactory.Options)options);
        this.srcWidth = options.outWidth;
        this.srcHeight = options.outHeight;
    }

    private int computeSize() {
        this.srcWidth = this.srcWidth % 2 == 1 ? this.srcWidth + 1 : this.srcWidth;
        this.srcHeight = this.srcHeight % 2 == 1 ? this.srcHeight + 1 : this.srcHeight;
        int longSide = Math.max(this.srcWidth, this.srcHeight);
        int shortSide = Math.min(this.srcWidth, this.srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 2;
            }
            if (longSide >= 1664 && longSide < 4990) {
                return 4;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 8;
            }
            return longSide / 1280 == 0 ? 2 : longSide / 1280 + 1;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 2 : longSide / 1280 + 1;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale)) + 1;
    }

    private Bitmap rotatingImage(Bitmap bitmap) {
        if (this.srcExif == null) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        int angle = 0;
        int orientation = this.srcExif.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                angle = 90;
                break;
            }
            case 3: {
                angle = 180;
                break;
            }
            case 8: {
                angle = 270;
                break;
            }
        }
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    File compress() throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize();
        Bitmap tagBitmap = BitmapFactory.decodeFile((String)this.srcImg, (BitmapFactory.Options)options);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        tagBitmap = this.rotatingImage(tagBitmap);
        tagBitmap.compress(Bitmap.CompressFormat.JPEG, 35, (OutputStream)stream);
        tagBitmap.recycle();
        FileOutputStream fos = new FileOutputStream(this.tagImg);
        fos.write(stream.toByteArray());
        fos.flush();
        fos.close();
        stream.close();
        return this.tagImg;
    }
}

