/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxtool;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

public class RxClipboardTool {
    public static void copyText(Context context, CharSequence text) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"text", (CharSequence)text));
    }

    public static CharSequence getText(Context context) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).coerceToText(context);
        }
        return null;
    }

    public static void copyUri(Context context, Uri uri) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        clipboard.setPrimaryClip(ClipData.newUri((ContentResolver)context.getContentResolver(), (CharSequence)"uri", (Uri)uri));
    }

    public static Uri getUri(Context context) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getUri();
        }
        return null;
    }

    public static void copyIntent(Context context, Intent intent) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        clipboard.setPrimaryClip(ClipData.newIntent((CharSequence)"intent", (Intent)intent));
    }

    public static Intent getIntent(Context context) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getIntent();
        }
        return null;
    }
}

