/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxtool;

import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.tamsiree.rxtool.view.RxToast;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class RxNetTool {
    public static final int NETWORK_NO = -1;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_UNKNOWN = 5;
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;

    public static int getNetWorkType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        int netType = -1;
        if (ni != null && ni.isConnectedOrConnecting()) {
            block0 : switch (ni.getType()) {
                case 1: {
                    netType = 1;
                    RxToast.success("\u5207\u6362\u5230wifi\u73af\u5883\u4e0b");
                    break;
                }
                case 0: {
                    switch (ni.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 16: {
                            netType = 2;
                            RxToast.info("\u5207\u6362\u52302G\u73af\u5883\u4e0b");
                            break block0;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 17: {
                            netType = 3;
                            RxToast.info("\u5207\u6362\u52303G\u73af\u5883\u4e0b");
                            break block0;
                        }
                        case 13: 
                        case 18: {
                            netType = 4;
                            RxToast.info("\u5207\u6362\u52304G\u73af\u5883\u4e0b");
                            break block0;
                        }
                    }
                    String subtypeName = ni.getSubtypeName();
                    netType = subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000") ? 3 : 5;
                    RxToast.normal("\u672a\u77e5\u7f51\u7edc");
                    break;
                }
                default: {
                    netType = 5;
                    RxToast.normal("\u672a\u77e5\u7f51\u7edc");
                    break;
                }
            }
        } else {
            netType = -1;
            RxToast.error(context, "\u5f53\u524d\u65e0\u7f51\u7edc\u8fde\u63a5").show();
        }
        return netType;
    }

    public static String getNetWorkTypeName(Context context) {
        switch (RxNetTool.getNetWorkType(context)) {
            case 1: {
                return "NETWORK_WIFI";
            }
            case 4: {
                return "NETWORK_4G";
            }
            case 3: {
                return "NETWORK_3G";
            }
            case 2: {
                return "NETWORK_2G";
            }
            case -1: {
                return "NETWORK_NO";
            }
        }
        return "NETWORK_UNKNOWN";
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo[] info;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm != null && (info = cm.getAllNetworkInfo()) != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAvailable(Context context) {
        NetworkInfo info = RxNetTool.getActiveNetworkInfo(context);
        return info != null && info.isAvailable();
    }

    public static boolean isConnected(Context context) {
        NetworkInfo info = RxNetTool.getActiveNetworkInfo(context);
        return info != null && info.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean ping() {
        String result;
        block7: {
            result = null;
            String ip = "www.baidu.com";
            Process p = Runtime.getRuntime().exec("ping -c 3 -w 100 " + ip);
            InputStream input = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            StringBuffer stringBuffer = new StringBuffer();
            String content = "";
            while ((content = in.readLine()) != null) {
                stringBuffer.append(content);
            }
            int status = p.waitFor();
            if (status != 0) break block7;
            result = "success";
            boolean bl = true;
            return bl;
        }
        try {
            result = "failed";
        }
        catch (IOException e) {
            result = "IOException";
        }
        catch (InterruptedException e) {
            result = "InterruptedException";
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean ping(String ip) {
        String result;
        block7: {
            result = null;
            Process p = Runtime.getRuntime().exec("ping -c 3 -w 100 " + ip);
            InputStream input = p.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            StringBuffer stringBuffer = new StringBuffer();
            String content = "";
            while ((content = in.readLine()) != null) {
                stringBuffer.append(content);
            }
            int status = p.waitFor();
            if (status != 0) break block7;
            result = "success";
            boolean bl = true;
            return bl;
        }
        try {
            result = "failed";
        }
        catch (IOException e) {
            result = "IOException";
        }
        catch (InterruptedException e) {
            result = "InterruptedException";
        }
        return false;
    }

    public static boolean isWifiEnabled(Context context) {
        ConnectivityManager mgrConn = (ConnectivityManager)context.getSystemService("connectivity");
        TelephonyManager mgrTel = (TelephonyManager)context.getSystemService("phone");
        return mgrConn.getActiveNetworkInfo() != null && mgrConn.getActiveNetworkInfo().getState() == NetworkInfo.State.CONNECTED || mgrTel.getNetworkType() == 3;
    }

    public static boolean isWifi(Context context) {
        NetworkInfo networkINfo = RxNetTool.getActiveNetworkInfo(context);
        return networkINfo != null && networkINfo.getType() == 1;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm != null && cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().getType() == 1;
    }

    public static boolean is3rd(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkINfo = cm.getActiveNetworkInfo();
        return networkINfo != null && networkINfo.getType() == 0;
    }

    public static boolean is4G(Context context) {
        NetworkInfo info = RxNetTool.getActiveNetworkInfo(context);
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    public static boolean isGpsEnabled(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        List accessibleProviders = lm.getProviders(true);
        return accessibleProviders != null && accessibleProviders.size() > 0;
    }

    public static void openWirelessSettings(Context context) {
        if (Build.VERSION.SDK_INT > 10) {
            context.startActivity(new Intent("android.settings.SETTINGS"));
        } else {
            context.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
        }
    }

    private static NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo();
    }

    public static String getNetworkOperatorName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getNetworkOperatorName() : null;
    }

    public static int getPhoneType(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm != null ? tm.getPhoneType() : -1;
    }
}

