/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.os.Build;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import com.vondear.rxtool.RxConstTool;
import com.vondear.rxtool.RxConstants;
import com.vondear.rxtool.RxFileTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;

public class RxDataTool {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final DecimalFormat AMOUNT_FORMAT = new DecimalFormat("###,###,###,##0.00");
    private static int[] pyValue = new int[]{-20319, -20317, -20304, -20295, -20292, -20283, -20265, -20257, -20242, -20230, -20051, -20036, -20032, -20026, -20002, -19990, -19986, -19982, -19976, -19805, -19784, -19775, -19774, -19763, -19756, -19751, -19746, -19741, -19739, -19728, -19725, -19715, -19540, -19531, -19525, -19515, -19500, -19484, -19479, -19467, -19289, -19288, -19281, -19275, -19270, -19263, -19261, -19249, -19243, -19242, -19238, -19235, -19227, -19224, -19218, -19212, -19038, -19023, -19018, -19006, -19003, -18996, -18977, -18961, -18952, -18783, -18774, -18773, -18763, -18756, -18741, -18735, -18731, -18722, -18710, -18697, -18696, -18526, -18518, -18501, -18490, -18478, -18463, -18448, -18447, -18446, -18239, -18237, -18231, -18220, -18211, -18201, -18184, -18183, -18181, -18012, -17997, -17988, -17970, -17964, -17961, -17950, -17947, -17931, -17928, -17922, -17759, -17752, -17733, -17730, -17721, -17703, -17701, -17697, -17692, -17683, -17676, -17496, -17487, -17482, -17468, -17454, -17433, -17427, -17417, -17202, -17185, -16983, -16970, -16942, -16915, -16733, -16708, -16706, -16689, -16664, -16657, -16647, -16474, -16470, -16465, -16459, -16452, -16448, -16433, -16429, -16427, -16423, -16419, -16412, -16407, -16403, -16401, -16393, -16220, -16216, -16212, -16205, -16202, -16187, -16180, -16171, -16169, -16158, -16155, -15959, -15958, -15944, -15933, -15920, -15915, -15903, -15889, -15878, -15707, -15701, -15681, -15667, -15661, -15659, -15652, -15640, -15631, -15625, -15454, -15448, -15436, -15435, -15419, -15416, -15408, -15394, -15385, -15377, -15375, -15369, -15363, -15362, -15183, -15180, -15165, -15158, -15153, -15150, -15149, -15144, -15143, -15141, -15140, -15139, -15128, -15121, -15119, -15117, -15110, -15109, -14941, -14937, -14933, -14930, -14929, -14928, -14926, -14922, -14921, -14914, -14908, -14902, -14894, -14889, -14882, -14873, -14871, -14857, -14678, -14674, -14670, -14668, -14663, -14654, -14645, -14630, -14594, -14429, -14407, -14399, -14384, -14379, -14368, -14355, -14353, -14345, -14170, -14159, -14151, -14149, -14145, -14140, -14137, -14135, -14125, -14123, -14122, -14112, -14109, -14099, -14097, -14094, -14092, -14090, -14087, -14083, -13917, -13914, -13910, -13907, -13906, -13905, -13896, -13894, -13878, -13870, -13859, -13847, -13831, -13658, -13611, -13601, -13406, -13404, -13400, -13398, -13395, -13391, -13387, -13383, -13367, -13359, -13356, -13343, -13340, -13329, -13326, -13318, -13147, -13138, -13120, -13107, -13096, -13095, -13091, -13076, -13068, -13063, -13060, -12888, -12875, -12871, -12860, -12858, -12852, -12849, -12838, -12831, -12829, -12812, -12802, -12607, -12597, -12594, -12585, -12556, -12359, -12346, -12320, -12300, -12120, -12099, -12089, -12074, -12067, -12058, -12039, -11867, -11861, -11847, -11831, -11798, -11781, -11604, -11589, -11536, -11358, -11340, -11339, -11324, -11303, -11097, -11077, -11067, -11055, -11052, -11045, -11041, -11038, -11024, -11020, -11019, -11018, -11014, -10838, -10832, -10815, -10800, -10790, -10780, -10764, -10587, -10544, -10533, -10519, -10331, -10329, -10328, -10322, -10315, -10309, -10307, -10296, -10281, -10274, -10270, -10262, -10260, -10256, -10254};
    private static String[] pyStr = new String[]{"a", "ai", "an", "ang", "ao", "ba", "bai", "ban", "bang", "bao", "bei", "ben", "beng", "bi", "bian", "biao", "bie", "bin", "bing", "bo", "bu", "ca", "cai", "can", "cang", "cao", "ce", "ceng", "cha", "chai", "chan", "chang", "chao", "che", "chen", "cheng", "chi", "chong", "chou", "chu", "chuai", "chuan", "chuang", "chui", "chun", "chuo", "ci", "cong", "cou", "cu", "cuan", "cui", "cun", "cuo", "da", "dai", "dan", "dang", "dao", "de", "deng", "di", "dian", "diao", "die", "ding", "diu", "dong", "dou", "du", "duan", "dui", "dun", "duo", "e", "en", "er", "fa", "fan", "fang", "fei", "fen", "feng", "fo", "fou", "fu", "ga", "gai", "gan", "gang", "gao", "ge", "gei", "gen", "geng", "gong", "gou", "gu", "gua", "guai", "guan", "guang", "gui", "gun", "guo", "ha", "hai", "han", "hang", "hao", "he", "hei", "hen", "heng", "hong", "hou", "hu", "hua", "huai", "huan", "huang", "hui", "hun", "huo", "ji", "jia", "jian", "jiang", "jiao", "jie", "jin", "jing", "jiong", "jiu", "ju", "juan", "jue", "jun", "ka", "kai", "kan", "kang", "kao", "ke", "ken", "keng", "kong", "kou", "ku", "kua", "kuai", "kuan", "kuang", "kui", "kun", "kuo", "la", "lai", "lan", "lang", "lao", "le", "lei", "leng", "li", "lia", "lian", "liang", "liao", "lie", "lin", "ling", "liu", "long", "lou", "lu", "lv", "luan", "lue", "lun", "luo", "ma", "mai", "man", "mang", "mao", "me", "mei", "men", "meng", "mi", "mian", "miao", "mie", "min", "ming", "miu", "mo", "mou", "mu", "na", "nai", "nan", "nang", "nao", "ne", "nei", "nen", "neng", "ni", "nian", "niang", "niao", "nie", "nin", "ning", "niu", "nong", "nu", "nv", "nuan", "nue", "nuo", "o", "ou", "pa", "pai", "pan", "pang", "pao", "pei", "pen", "peng", "pi", "pian", "piao", "pie", "pin", "ping", "po", "pu", "qi", "qia", "qian", "qiang", "qiao", "qie", "qin", "qing", "qiong", "qiu", "qu", "quan", "que", "qun", "ran", "rang", "rao", "re", "ren", "reng", "ri", "rong", "rou", "ru", "ruan", "rui", "run", "ruo", "sa", "sai", "san", "sang", "sao", "se", "sen", "seng", "sha", "shai", "shan", "shang", "shao", "she", "shen", "sheng", "shi", "shou", "shu", "shua", "shuai", "shuan", "shuang", "shui", "shun", "shuo", "si", "song", "sou", "su", "suan", "sui", "sun", "suo", "ta", "tai", "tan", "tang", "tao", "te", "teng", "ti", "tian", "tiao", "tie", "ting", "tong", "tou", "tu", "tuan", "tui", "tun", "tuo", "wa", "wai", "wan", "wang", "wei", "wen", "weng", "wo", "wu", "xi", "xia", "xian", "xiang", "xiao", "xie", "xin", "xing", "xiong", "xiu", "xu", "xuan", "xue", "xun", "ya", "yan", "yang", "yao", "ye", "yi", "yin", "ying", "yo", "yong", "you", "yu", "yuan", "yue", "yun", "za", "zai", "zan", "zang", "zao", "ze", "zei", "zen", "zeng", "zha", "zhai", "zhan", "zhang", "zhao", "zhe", "zhen", "zheng", "zhi", "zhong", "zhou", "zhu", "zhua", "zhuai", "zhuan", "zhuang", "zhui", "zhun", "zhuo", "zi", "zong", "zou", "zu", "zuan", "zui", "zun", "zuo"};

    public static boolean isNullString(@Nullable String str) {
        return str == null || str.length() == 0 || "null".equals(str);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && obj.toString().length() == 0) {
            return true;
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            return true;
        }
        if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof Map && ((Map)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof SparseArray && ((SparseArray)obj).size() == 0) {
            return true;
        }
        if (obj instanceof SparseBooleanArray && ((SparseBooleanArray)obj).size() == 0) {
            return true;
        }
        if (obj instanceof SparseIntArray && ((SparseIntArray)obj).size() == 0) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return obj instanceof SparseLongArray && ((SparseLongArray)obj).size() == 0;
        }
        return false;
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return value.contains(".");
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNumber(String value) {
        return RxDataTool.isInteger(value) || RxDataTool.isDouble(value);
    }

    public static String getAstro(int month, int day) {
        String[] starArr = new String[]{"\u9b54\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u7261\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7"};
        int[] DayArr = new int[]{22, 20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22};
        if (month <= 0 || day <= 0) {
            return "\u7334\u5e74\u9a6c\u6708\u5ea7";
        }
        if (month > 12 || day > 31) {
            return "\u7334\u5e74\u9a6c\u6708\u5ea7";
        }
        int index = month;
        if (day < DayArr[month - 1]) {
            --index;
        }
        return starArr[index];
    }

    public static String hideMobilePhone4(String mobile_phone) {
        if (mobile_phone.length() != 11) {
            return "\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e";
        }
        return mobile_phone.substring(0, 3) + "****" + mobile_phone.substring(7, 11);
    }

    public static String formatCard(String cardNo) {
        if (cardNo.length() < 8) {
            return "\u94f6\u884c\u5361\u53f7\u6709\u8bef";
        }
        String card = "";
        card = cardNo.substring(0, 4) + " **** **** ";
        card = card + cardNo.substring(cardNo.length() - 4);
        return card;
    }

    public static String formatCardEnd4(String cardNo) {
        if (cardNo.length() < 8) {
            return "\u94f6\u884c\u5361\u53f7\u6709\u8bef";
        }
        String card = "";
        card = card + cardNo.substring(cardNo.length() - 4);
        return card;
    }

    public static int stringToInt(String str) {
        if (RxDataTool.isNullString(str)) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int[] stringToInts(String s) {
        int[] n = new int[s.length()];
        if (!RxDataTool.isNullString(s)) {
            for (int i = 0; i < s.length(); ++i) {
                n[i] = Integer.parseInt(s.substring(i, i + 1));
            }
        }
        return n;
    }

    public static int intsGetSum(int[] ints) {
        int sum = 0;
        int len = ints.length;
        for (int i = 0; i < len; ++i) {
            sum += ints[i];
        }
        return sum;
    }

    public static long stringToLong(String str) {
        if (RxDataTool.isNullString(str)) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static double stringToDouble(String str) {
        if (RxDataTool.isNullString(str)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static float stringToFloat(String str) {
        if (RxDataTool.isNullString(str)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static String format2Decimals(String str) {
        DecimalFormat df = new DecimalFormat("#.00");
        if (df.format(RxDataTool.stringToDouble(str)).startsWith(".")) {
            return "0" + df.format(RxDataTool.stringToDouble(str));
        }
        return df.format(RxDataTool.stringToDouble(str));
    }

    public static InputStream StringToInputStream(String str) {
        ByteArrayInputStream in_nocode = new ByteArrayInputStream(str.getBytes());
        return in_nocode;
    }

    public static String upperFirstLetter(String s) {
        if (RxDataTool.isNullString(s) || !Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) - 32)) + s.substring(1);
    }

    public static String lowerFirstLetter(String s) {
        if (RxDataTool.isNullString(s) || !Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) + 32)) + s.substring(1);
    }

    public static String reverse(String s) {
        int len = s.length();
        if (len <= 1) {
            return s;
        }
        int mid = len >> 1;
        char[] chars = s.toCharArray();
        for (int i = 0; i < mid; ++i) {
            char c = chars[i];
            chars[i] = chars[len - i - 1];
            chars[len - i - 1] = c;
        }
        return new String(chars);
    }

    public static String toDBC(String s) {
        if (RxDataTool.isNullString(s)) {
            return s;
        }
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == '\u3000' ? 32 : ('\uff01' <= chars[i] && chars[i] <= '\uff5e' ? (char)(chars[i] - 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static String toSBC(String s) {
        if (RxDataTool.isNullString(s)) {
            return s;
        }
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == ' ' ? 12288 : ('!' <= chars[i] && chars[i] <= '~' ? (char)(chars[i] + 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static int oneCn2ASCII(String s) {
        int ascii;
        block5: {
            if (s.length() != 1) {
                return -1;
            }
            ascii = 0;
            try {
                byte[] bytes = s.getBytes("GB2312");
                if (bytes.length == 1) {
                    ascii = bytes[0];
                    break block5;
                }
                if (bytes.length == 2) {
                    int highByte = 256 + bytes[0];
                    int lowByte = 256 + bytes[1];
                    ascii = 256 * highByte + lowByte - 65536;
                    break block5;
                }
                throw new IllegalArgumentException("Illegal resource string");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return ascii;
    }

    public static String oneCn2PY(String s) {
        int ascii = RxDataTool.oneCn2ASCII(s);
        if (ascii == -1) {
            return null;
        }
        String ret = null;
        if (0 <= ascii && ascii <= 127) {
            ret = String.valueOf((char)ascii);
        } else {
            for (int i = pyValue.length - 1; i >= 0; --i) {
                if (pyValue[i] > ascii) continue;
                ret = pyStr[i];
                break;
            }
        }
        return ret;
    }

    public static String getPYFirstLetter(String s) {
        if (RxDataTool.isNullString(s)) {
            return "";
        }
        String first = s.substring(0, 1);
        String py = RxDataTool.oneCn2PY(first);
        if (py == null) {
            return null;
        }
        return py.substring(0, 1);
    }

    public static String cn2PY(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String hz = s.substring(i, i + 1);
            String py = RxDataTool.oneCn2PY(hz);
            if (py == null) {
                py = "?";
            }
            sb.append(py);
        }
        return sb.toString();
    }

    public static String bytes2HexString(byte[] bytes) {
        char[] ret = new char[bytes.length << 1];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >>> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    public static byte[] hexString2Bytes(String hexString) {
        int len = hexString.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570");
        }
        char[] hexBytes = hexString.toUpperCase().toCharArray();
        byte[] ret = new byte[len >>> 1];
        for (int i = 0; i < len; i += 2) {
            ret[i >> 1] = (byte)(RxDataTool.hex2Dec(hexBytes[i]) << 4 | RxDataTool.hex2Dec(hexBytes[i + 1]));
        }
        return ret;
    }

    private static int hex2Dec(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    public static byte[] chars2Bytes(char[] chars) {
        int len = chars.length;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static char[] bytes2Chars(byte[] bytes) {
        int len = bytes.length;
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    public static double byte2Size(long byteNum, RxConstTool.MemoryUnit unit) {
        if (byteNum < 0L) {
            return -1.0;
        }
        switch (unit) {
            default: {
                return (double)byteNum / 1.0;
            }
            case KB: {
                return (double)byteNum / 1024.0;
            }
            case MB: {
                return (double)byteNum / 1048576.0;
            }
            case GB: 
        }
        return (double)byteNum / 1.073741824E9;
    }

    public static long size2Byte(long size, RxConstTool.MemoryUnit unit) {
        if (size < 0L) {
            return -1L;
        }
        switch (unit) {
            default: {
                return size * 1L;
            }
            case KB: {
                return size * 1024L;
            }
            case MB: {
                return size * 0x100000L;
            }
            case GB: 
        }
        return size * 0x40000000L;
    }

    public static String byte2FitSize(long byteNum) {
        if (byteNum < 0L) {
            return "shouldn't be less than zero!";
        }
        if (byteNum < 1024L) {
            return String.format(Locale.getDefault(), "%.3fB", (double)byteNum);
        }
        if (byteNum < 0x100000L) {
            return String.format(Locale.getDefault(), "%.3fKB", (double)byteNum / 1024.0);
        }
        if (byteNum < 0x40000000L) {
            return String.format(Locale.getDefault(), "%.3fMB", (double)byteNum / 1048576.0);
        }
        return String.format(Locale.getDefault(), "%.3fGB", (double)byteNum / 1.073741824E9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream input2OutputStream(InputStream is) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (is == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                os.write(b, 0, len);
            }
            byteArrayOutputStream = os;
        }
        catch (IOException e) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                e.printStackTrace();
                byteArrayOutputStream2 = null;
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(is);
                throw throwable;
            }
            RxFileTool.closeIO(is);
            return byteArrayOutputStream2;
        }
        RxFileTool.closeIO(is);
        return byteArrayOutputStream;
    }

    public static byte[] inputStream2Bytes(InputStream is) {
        return RxDataTool.input2OutputStream(is).toByteArray();
    }

    public static InputStream bytes2InputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static byte[] outputStream2Bytes(OutputStream out) {
        if (out == null) {
            return null;
        }
        return ((ByteArrayOutputStream)out).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream bytes2OutputStream(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            os.write(bytes);
            byteArrayOutputStream = os;
        }
        catch (IOException e) {
            OutputStream outputStream;
            try {
                e.printStackTrace();
                outputStream = null;
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(os);
                throw throwable;
            }
            RxFileTool.closeIO(os);
            return outputStream;
        }
        RxFileTool.closeIO(os);
        return byteArrayOutputStream;
    }

    public static String inputStream2String(InputStream is, String charsetName) {
        if (is == null || RxDataTool.isNullString(charsetName)) {
            return null;
        }
        try {
            return new String(RxDataTool.inputStream2Bytes(is), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream string2InputStream(String string, String charsetName) {
        if (string == null || RxDataTool.isNullString(charsetName)) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String outputStream2String(OutputStream out, String charsetName) {
        if (out == null) {
            return null;
        }
        try {
            return new String(RxDataTool.outputStream2Bytes(out), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OutputStream string2OutputStream(String string, String charsetName) {
        if (string == null || RxDataTool.isNullString(charsetName)) {
            return null;
        }
        try {
            return RxDataTool.bytes2OutputStream(string.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAmountValue(double value) {
        return AMOUNT_FORMAT.format(value);
    }

    public static String getAmountValue(String value) {
        if (RxDataTool.isNullString(value)) {
            return "0";
        }
        return AMOUNT_FORMAT.format(Double.parseDouble(value));
    }

    public static String getRoundUp(BigDecimal value, int digit) {
        return value.setScale(digit, 4).toString();
    }

    public static String getRoundUp(double value, int digit) {
        BigDecimal result = new BigDecimal(value);
        return result.setScale(digit, 4).toString();
    }

    public static String getRoundUp(String value, int digit) {
        if (RxDataTool.isNullString(value)) {
            return "0";
        }
        BigDecimal result = new BigDecimal(Double.parseDouble(value));
        return result.setScale(digit, 4).toString();
    }

    public static String getPercentValue(BigDecimal value, int digit) {
        BigDecimal result = value.multiply(new BigDecimal(100));
        return RxDataTool.getRoundUp(result, digit);
    }

    public static String getPercentValue(double value, int digit) {
        BigDecimal result = new BigDecimal(value);
        return RxDataTool.getPercentValue(result, digit);
    }

    public static String getPercentValue(double value) {
        BigDecimal result = new BigDecimal(value);
        return RxDataTool.getPercentValue(result, 2);
    }

    public static String changeDistance(double length) {
        if (length < 1000.0) {
            return RxConstants.FORMAT_TWO.format(length) + "\u7c73";
        }
        return RxConstants.FORMAT_TWO.format(length / 1000.0) + "\u5343\u7c73";
    }

    public ByteArrayInputStream output2InputStream(OutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
    }
}

