/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.vondear.rxtool.RxDataTool;
import com.vondear.rxtool.RxImageTool;
import java.io.File;
import java.io.IOException;

public class RxPictureTool {
    public static Intent getOpenCameraIntent() {
        return new Intent("android.media.action.IMAGE_CAPTURE");
    }

    public static Intent getImagePickerIntent() {
        Intent intent = new Intent("android.intent.action.PICK", null);
        return intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
    }

    public static Intent getImagePickerIntent(int outputX, int outputY, Uri fromFileURI, Uri saveFileURI) {
        return RxPictureTool.getImagePickerIntent(1, 1, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    public static Intent getImagePickerIntent(int aspectX, int aspectY, int outputX, int outputY, Uri fromFileURI, Uri saveFileURI) {
        return RxPictureTool.getImagePickerIntent(aspectX, aspectY, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    public static Intent getImagePickerIntent(int aspectX, int aspectY, int outputX, int outputY, boolean canScale, Uri fromFileURI, Uri saveFileURI) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setDataAndType(fromFileURI, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", aspectX <= 0 ? 1 : aspectX);
        intent.putExtra("aspectY", aspectY <= 0 ? 1 : aspectY);
        intent.putExtra("outputX", outputX);
        intent.putExtra("outputY", outputY);
        intent.putExtra("scale", canScale);
        intent.putExtra("scaleUpIfNeeded", true);
        intent.putExtra("return-data", false);
        intent.putExtra("output", (Parcelable)saveFileURI);
        intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        return intent.putExtra("noFaceDetection", true);
    }

    public static Intent getCameraIntent(Uri saveFileURI) {
        Intent mIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        return mIntent.putExtra("output", (Parcelable)saveFileURI);
    }

    public static Intent getCropImageIntent(int outputX, int outputY, Uri fromFileURI, Uri saveFileURI) {
        return RxPictureTool.getCropImageIntent(1, 1, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    public static Intent getCropImageIntent(int aspectX, int aspectY, int outputX, int outputY, Uri fromFileURI, Uri saveFileURI) {
        return RxPictureTool.getCropImageIntent(aspectX, aspectY, outputX, outputY, true, fromFileURI, saveFileURI);
    }

    public static Intent getCropImageIntent(int aspectX, int aspectY, int outputX, int outputY, boolean canScale, Uri fromFileURI, Uri saveFileURI) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(fromFileURI, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", aspectX <= 0 ? 1 : aspectX);
        intent.putExtra("aspectY", aspectY <= 0 ? 1 : aspectY);
        intent.putExtra("outputX", outputX);
        intent.putExtra("outputY", outputY);
        intent.putExtra("scale", canScale);
        intent.putExtra("scaleUpIfNeeded", true);
        intent.putExtra("return-data", false);
        intent.putExtra("output", (Parcelable)saveFileURI);
        intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        intent.putExtra("noFaceDetection", true);
        return intent;
    }

    public static Bitmap getChoosedImage(Activity context, Intent data) {
        if (data == null) {
            return null;
        }
        Bitmap bm = null;
        ContentResolver cr = context.getContentResolver();
        Uri originalUri = data.getData();
        try {
            bm = MediaStore.Images.Media.getBitmap((ContentResolver)cr, (Uri)originalUri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getChoosedImagePath(Activity context, Intent data) {
        if (data == null) {
            return null;
        }
        String path = "";
        ContentResolver resolver = context.getContentResolver();
        Uri originalUri = data.getData();
        if (null == originalUri) {
            return null;
        }
        String[] projection = new String[]{"_data"};
        Cursor cursor = resolver.query(originalUri, projection, null, null, null);
        if (null != cursor) {
            try {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                path = cursor.getString(column_index);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (!cursor.isClosed()) {
                        cursor.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return RxDataTool.isNullString(path) ? originalUri.getPath() : null;
    }

    public static File getTakePictureFile(Intent data, String filePath) {
        File file;
        if (data == null) {
            return null;
        }
        Bundle extras = data.getExtras();
        if (extras == null) {
            return null;
        }
        Bitmap photo = (Bitmap)extras.getParcelable("data");
        if (RxImageTool.save(photo, file = new File(filePath), Bitmap.CompressFormat.JPEG)) {
            return file;
        }
        return null;
    }
}

