/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids.modifiers;

import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.plattysoft.leonids.Particle;
import com.plattysoft.leonids.modifiers.ParticleModifier;

public class ScaleModifier
implements ParticleModifier {
    private float mInitialValue;
    private float mFinalValue;
    private long mEndTime;
    private long mStartTime;
    private long mDuration;
    private float mValueIncrement;
    private Interpolator mInterpolator;

    public ScaleModifier(float initialValue, float finalValue, long startMilis, long endMilis, Interpolator interpolator) {
        this.mInitialValue = initialValue;
        this.mFinalValue = finalValue;
        this.mStartTime = startMilis;
        this.mEndTime = endMilis;
        this.mDuration = this.mEndTime - this.mStartTime;
        this.mValueIncrement = this.mFinalValue - this.mInitialValue;
        this.mInterpolator = interpolator;
    }

    public ScaleModifier(float initialValue, float finalValue, long startMilis, long endMilis) {
        this(initialValue, finalValue, startMilis, endMilis, (Interpolator)new LinearInterpolator());
    }

    @Override
    public void apply(Particle particle, long milliseconds) {
        if (milliseconds < this.mStartTime) {
            particle.mScale = this.mInitialValue;
        } else if (milliseconds > this.mEndTime) {
            particle.mScale = this.mFinalValue;
        } else {
            float interpolatedValue = this.mInterpolator.getInterpolation((float)(milliseconds - this.mStartTime) * 1.0f / (float)this.mDuration);
            particle.mScale = this.mInitialValue + this.mValueIncrement * interpolatedValue;
        }
    }
}

