/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids.initializers;

import com.plattysoft.leonids.Particle;
import com.plattysoft.leonids.initializers.ParticleInitializer;
import java.util.Random;

public class SpeeddModuleAndRangeInitializer
implements ParticleInitializer {
    private float mSpeedMin;
    private float mSpeedMax;
    private int mMinAngle;
    private int mMaxAngle;

    public SpeeddModuleAndRangeInitializer(float speedMin, float speedMax, int minAngle, int maxAngle) {
        this.mSpeedMin = speedMin;
        this.mSpeedMax = speedMax;
        this.mMinAngle = minAngle;
        this.mMaxAngle = maxAngle;
        while (this.mMinAngle < 0) {
            this.mMinAngle += 360;
        }
        while (this.mMaxAngle < 0) {
            this.mMaxAngle += 360;
        }
        if (this.mMinAngle > this.mMaxAngle) {
            int tmp = this.mMinAngle;
            this.mMinAngle = this.mMaxAngle;
            this.mMaxAngle = tmp;
        }
    }

    @Override
    public void initParticle(Particle p, Random r) {
        float speed = r.nextFloat() * (this.mSpeedMax - this.mSpeedMin) + this.mSpeedMin;
        int angle = this.mMaxAngle == this.mMinAngle ? this.mMinAngle : r.nextInt(this.mMaxAngle - this.mMinAngle) + this.mMinAngle;
        float angleInRads = (float)((double)angle * Math.PI / 180.0);
        p.mSpeedX = (float)((double)speed * Math.cos(angleInRads));
        p.mSpeedY = (float)((double)speed * Math.sin(angleInRads));
    }
}

