/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids.initializers;

import com.plattysoft.leonids.Particle;
import com.plattysoft.leonids.initializers.ParticleInitializer;
import java.util.Random;

public class AccelerationInitializer
implements ParticleInitializer {
    private float mMinValue;
    private float mMaxValue;
    private int mMinAngle;
    private int mMaxAngle;

    public AccelerationInitializer(float minAcceleration, float maxAcceleration, int minAngle, int maxAngle) {
        this.mMinValue = minAcceleration;
        this.mMaxValue = maxAcceleration;
        this.mMinAngle = minAngle;
        this.mMaxAngle = maxAngle;
    }

    @Override
    public void initParticle(Particle p, Random r) {
        float angle = this.mMinAngle;
        if (this.mMaxAngle != this.mMinAngle) {
            angle = r.nextInt(this.mMaxAngle - this.mMinAngle) + this.mMinAngle;
        }
        float angleInRads = (float)((double)angle * Math.PI / 180.0);
        float value = r.nextFloat() * (this.mMaxValue - this.mMinValue) + this.mMinValue;
        p.mAccelerationX = (float)((double)value * Math.cos(angleInRads));
        p.mAccelerationY = (float)((double)value * Math.sin(angleInRads));
    }
}

