/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.plattysoft.leonids.modifiers.ParticleModifier;
import java.util.List;

public class Particle {
    protected Bitmap mImage;
    public float mCurrentX;
    public float mCurrentY;
    public float mScale = 1.0f;
    public int mAlpha = 255;
    public float mInitialRotation = 0.0f;
    public float mRotationSpeed = 0.0f;
    public float mSpeedX = 0.0f;
    public float mSpeedY = 0.0f;
    public float mAccelerationX;
    public float mAccelerationY;
    private Matrix mMatrix = new Matrix();
    private Paint mPaint = new Paint();
    private float mInitialX;
    private float mInitialY;
    private float mRotation;
    private long mTimeToLive;
    protected long mStartingMilisecond;
    private int mBitmapHalfWidth;
    private int mBitmapHalfHeight;
    private List<ParticleModifier> mModifiers;

    protected Particle() {
    }

    public Particle(Bitmap bitmap) {
        this();
        this.mImage = bitmap;
    }

    public void init() {
        this.mScale = 1.0f;
        this.mAlpha = 255;
    }

    public void configure(long timeToLive, float emiterX, float emiterY) {
        this.mBitmapHalfWidth = this.mImage.getWidth() / 2;
        this.mBitmapHalfHeight = this.mImage.getHeight() / 2;
        this.mInitialX = emiterX - (float)this.mBitmapHalfWidth;
        this.mInitialY = emiterY - (float)this.mBitmapHalfHeight;
        this.mCurrentX = this.mInitialX;
        this.mCurrentY = this.mInitialY;
        this.mTimeToLive = timeToLive;
    }

    public boolean update(long miliseconds) {
        long realMiliseconds = miliseconds - this.mStartingMilisecond;
        if (realMiliseconds > this.mTimeToLive) {
            return false;
        }
        this.mCurrentX = this.mInitialX + this.mSpeedX * (float)realMiliseconds + this.mAccelerationX * (float)realMiliseconds * (float)realMiliseconds;
        this.mCurrentY = this.mInitialY + this.mSpeedY * (float)realMiliseconds + this.mAccelerationY * (float)realMiliseconds * (float)realMiliseconds;
        this.mRotation = this.mInitialRotation + this.mRotationSpeed * (float)realMiliseconds / 1000.0f;
        for (int i = 0; i < this.mModifiers.size(); ++i) {
            this.mModifiers.get(i).apply(this, realMiliseconds);
        }
        return true;
    }

    public void draw(Canvas c) {
        this.mMatrix.reset();
        this.mMatrix.postRotate(this.mRotation, (float)this.mBitmapHalfWidth, (float)this.mBitmapHalfHeight);
        this.mMatrix.postScale(this.mScale, this.mScale, (float)this.mBitmapHalfWidth, (float)this.mBitmapHalfHeight);
        this.mMatrix.postTranslate(this.mCurrentX, this.mCurrentY);
        this.mPaint.setAlpha(this.mAlpha);
        c.drawBitmap(this.mImage, this.mMatrix, this.mPaint);
    }

    public Particle activate(long startingMilisecond, List<ParticleModifier> modifiers) {
        this.mStartingMilisecond = startingMilisecond;
        this.mModifiers = modifiers;
        return this;
    }
}

