/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids.modifiers;

import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.plattysoft.leonids.Particle;
import com.plattysoft.leonids.modifiers.ParticleModifier;

public class AlphaModifier
implements ParticleModifier {
    private int mInitialValue;
    private int mFinalValue;
    private long mStartTime;
    private long mEndTime;
    private float mDuration;
    private float mValueIncrement;
    private Interpolator mInterpolator;

    public AlphaModifier(int initialValue, int finalValue, long startMilis, long endMilis, Interpolator interpolator) {
        this.mInitialValue = initialValue;
        this.mFinalValue = finalValue;
        this.mStartTime = startMilis;
        this.mEndTime = endMilis;
        this.mDuration = this.mEndTime - this.mStartTime;
        this.mValueIncrement = this.mFinalValue - this.mInitialValue;
        this.mInterpolator = interpolator;
    }

    public AlphaModifier(int initialValue, int finalValue, long startMilis, long endMilis) {
        this(initialValue, finalValue, startMilis, endMilis, (Interpolator)new LinearInterpolator());
    }

    @Override
    public void apply(Particle particle, long miliseconds) {
        if (miliseconds < this.mStartTime) {
            particle.mAlpha = this.mInitialValue;
        } else if (miliseconds > this.mEndTime) {
            particle.mAlpha = this.mFinalValue;
        } else {
            int newAlphaValue;
            float interpolaterdValue = this.mInterpolator.getInterpolation((float)(miliseconds - this.mStartTime) * 1.0f / this.mDuration);
            particle.mAlpha = newAlphaValue = (int)((float)this.mInitialValue + this.mValueIncrement * interpolaterdValue);
        }
    }
}

