/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.animation.ObjectAnimator;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.animation.DynamicAnimation;
import android.support.animation.FlingAnimation;
import android.support.animation.FloatPropertyCompat;
import android.support.animation.SpringAnimation;
import android.support.animation.SpringForce;
import android.view.View;
import com.takusemba.cropme.MoveAnimator;

class VerticalMoveAnimatorImpl
implements MoveAnimator {
    private SpringAnimation spring;
    private FlingAnimation fling;
    private ObjectAnimator animator;
    private RectF restrictionRect;
    private int maxScale;
    private DynamicAnimation.OnAnimationUpdateListener updateListener = new DynamicAnimation.OnAnimationUpdateListener(){

        public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float value, float velocity) {
            VerticalMoveAnimatorImpl.this.reMoveIfNeeded(velocity);
        }
    };
    private DynamicAnimation.OnAnimationEndListener endListener = new DynamicAnimation.OnAnimationEndListener(){

        public void onAnimationEnd(DynamicAnimation dynamicAnimation, boolean b, float v, float v1) {
            VerticalMoveAnimatorImpl.this.isFlinging = false;
        }
    };
    private boolean isFlinging = false;

    VerticalMoveAnimatorImpl(View target, RectF restrictionRect, int maxScale) {
        this.maxScale = maxScale;
        this.restrictionRect = restrictionRect;
        this.spring = new SpringAnimation((Object)target, (FloatPropertyCompat)new FloatPropertyCompat<View>("Y"){

            public float getValue(View view) {
                return view.getY();
            }

            public void setValue(View view, float value) {
                view.setY(value);
            }
        }).setSpring(new SpringForce().setStiffness(50.0f).setDampingRatio(1.0f));
        this.fling = new FlingAnimation((Object)target, (FloatPropertyCompat)DynamicAnimation.Y).setFriction(3.0f);
        this.animator = new ObjectAnimator();
        this.animator.setProperty(View.TRANSLATION_Y);
        this.animator.setTarget((Object)target);
    }

    @Override
    public void move(float delta) {
        View target = (View)this.animator.getTarget();
        if (target != null) {
            this.cancel();
            this.animator.setInterpolator(null);
            this.animator.setDuration(0L);
            this.animator.setFloatValues(new float[]{target.getTranslationY() + delta});
            this.animator.start();
        }
    }

    @Override
    public void reMoveIfNeeded(float velocity) {
        View target = (View)this.animator.getTarget();
        if (target != null) {
            Rect afterRect;
            int heightDiff;
            float scale;
            Rect targetRect = new Rect();
            target.getHitRect(targetRect);
            if ((float)this.maxScale < target.getScaleY()) {
                scale = this.maxScale;
                heightDiff = (int)(((float)targetRect.height() - (float)targetRect.height() * ((float)this.maxScale / target.getScaleY())) / 2.0f);
                int widthDiff = (int)(((float)targetRect.width() - (float)targetRect.width() * ((float)this.maxScale / target.getScaleY())) / 2.0f);
                afterRect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
            } else if (target.getScaleY() < 1.0f) {
                scale = 1.0f;
                heightDiff = (target.getHeight() - targetRect.height()) / 2;
                int widthDiff = (target.getWidth() - targetRect.width()) / 2;
                afterRect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
            } else {
                scale = target.getScaleY();
                afterRect = targetRect;
            }
            float verticalDiff = ((float)target.getHeight() * scale - (float)target.getHeight()) / 2.0f;
            if (this.restrictionRect.top < (float)afterRect.top) {
                this.cancel();
                ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(this.restrictionRect.top + verticalDiff);
            } else if ((float)afterRect.bottom < this.restrictionRect.bottom) {
                this.cancel();
                ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(this.restrictionRect.bottom - (float)target.getHeight() - verticalDiff);
            }
        }
    }

    @Override
    public void fling(float velocity) {
        this.cancel();
        this.isFlinging = true;
        this.fling.addUpdateListener(this.updateListener);
        this.fling.addEndListener(this.endListener);
        this.fling.setStartVelocity(velocity).start();
    }

    @Override
    public boolean isNotFlinging() {
        return !this.isFlinging;
    }

    private void cancel() {
        this.isFlinging = false;
        this.animator.cancel();
        this.spring.cancel();
        this.fling.cancel();
        this.fling.removeUpdateListener(this.updateListener);
        this.fling.removeEndListener(this.endListener);
    }
}

