/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.takusemba.cropme.ScaleAnimator;

class ScaleAnimatorImpl
implements ScaleAnimator {
    private static final int DURATION = 600;
    private static final int FACTOR = 2;
    private ObjectAnimator animatorX;
    private ObjectAnimator animatorY;
    private int maxScale;

    ScaleAnimatorImpl(View target, int maxScale) {
        this.maxScale = maxScale;
        this.animatorX = new ObjectAnimator();
        this.animatorX.setProperty(View.SCALE_X);
        this.animatorX.setTarget((Object)target);
        this.animatorY = new ObjectAnimator();
        this.animatorY.setProperty(View.SCALE_Y);
        this.animatorY.setTarget((Object)target);
    }

    @Override
    public void scale(float scale) {
        View targetY;
        View targetX = (View)this.animatorX.getTarget();
        if (targetX != null) {
            this.animatorX.cancel();
            this.animatorX.setDuration(0L);
            this.animatorX.setInterpolator(null);
            this.animatorX.setFloatValues(new float[]{targetX.getScaleX() * scale});
            this.animatorX.start();
        }
        if ((targetY = (View)this.animatorY.getTarget()) != null) {
            this.animatorY.cancel();
            this.animatorY.setDuration(0L);
            this.animatorY.setInterpolator(null);
            this.animatorY.setFloatValues(new float[]{targetY.getScaleY() * scale});
            this.animatorY.start();
        }
    }

    @Override
    public void reScaleIfNeeded() {
        View targetY;
        View targetX = (View)this.animatorX.getTarget();
        if (targetX != null) {
            if (targetX.getScaleX() < 1.0f) {
                this.animatorX.cancel();
                this.animatorX.setDuration(600L);
                this.animatorX.setFloatValues(new float[]{1.0f});
                this.animatorX.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                this.animatorX.start();
            } else if ((float)this.maxScale < targetX.getScaleX()) {
                this.animatorX.cancel();
                this.animatorX.setDuration(600L);
                this.animatorX.setFloatValues(new float[]{this.maxScale});
                this.animatorX.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                this.animatorX.start();
            }
        }
        if ((targetY = (View)this.animatorY.getTarget()) != null) {
            if (targetY.getScaleY() < 1.0f) {
                this.animatorY.cancel();
                this.animatorY.setDuration(600L);
                this.animatorY.setFloatValues(new float[]{1.0f});
                this.animatorY.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                this.animatorY.start();
            } else if ((float)this.maxScale < targetY.getScaleY()) {
                this.animatorY.cancel();
                this.animatorY.setDuration(600L);
                this.animatorY.setFloatValues(new float[]{this.maxScale});
                this.animatorY.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
                this.animatorY.start();
            }
        }
    }
}

