/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.animation.ObjectAnimator;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.animation.DynamicAnimation;
import android.support.animation.FlingAnimation;
import android.support.animation.FloatPropertyCompat;
import android.support.animation.SpringAnimation;
import android.support.animation.SpringForce;
import android.view.View;
import com.takusemba.cropme.MoveAnimator;

class HorizontalMoveAnimatorImpl
implements MoveAnimator {
    private SpringAnimation spring;
    private FlingAnimation fling;
    private ObjectAnimator animator;
    private RectF restrictionRect;
    private int maxScale;
    private DynamicAnimation.OnAnimationUpdateListener updateListener = new DynamicAnimation.OnAnimationUpdateListener(){

        public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float value, float velocity) {
            HorizontalMoveAnimatorImpl.this.reMoveIfNeeded(velocity);
        }
    };
    private DynamicAnimation.OnAnimationEndListener endListener = new DynamicAnimation.OnAnimationEndListener(){

        public void onAnimationEnd(DynamicAnimation dynamicAnimation, boolean b, float v, float v1) {
            HorizontalMoveAnimatorImpl.this.isFlinging = false;
        }
    };
    private boolean isFlinging = false;

    HorizontalMoveAnimatorImpl(View target, RectF restrictionRect, int maxScale) {
        this.maxScale = maxScale;
        this.restrictionRect = restrictionRect;
        this.spring = new SpringAnimation((Object)target, (FloatPropertyCompat)new FloatPropertyCompat<View>("X"){

            public float getValue(View view) {
                return view.getX();
            }

            public void setValue(View view, float value) {
                view.setX(value);
            }
        }).setSpring(new SpringForce().setStiffness(50.0f).setDampingRatio(1.0f));
        this.fling = new FlingAnimation((Object)target, (FloatPropertyCompat)DynamicAnimation.X).setFriction(3.0f);
        this.animator = new ObjectAnimator();
        this.animator.setProperty(View.TRANSLATION_X);
        this.animator.setTarget((Object)target);
    }

    @Override
    public void move(float delta) {
        View target = (View)this.animator.getTarget();
        if (target != null) {
            this.cancel();
            this.animator.setInterpolator(null);
            this.animator.setDuration(0L);
            this.animator.setFloatValues(new float[]{target.getTranslationX() + delta});
            this.animator.start();
        }
    }

    @Override
    public void reMoveIfNeeded(float velocity) {
        View target = (View)this.animator.getTarget();
        if (target != null) {
            Rect afterRect;
            int heightDiff;
            float scale;
            Rect targetRect = new Rect();
            target.getHitRect(targetRect);
            if ((float)this.maxScale < target.getScaleX()) {
                scale = this.maxScale;
                heightDiff = (int)(((float)targetRect.height() - (float)targetRect.height() * ((float)this.maxScale / target.getScaleY())) / 2.0f);
                int widthDiff = (int)(((float)targetRect.width() - (float)targetRect.width() * ((float)this.maxScale / target.getScaleY())) / 2.0f);
                afterRect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
            } else if (target.getScaleX() < 1.0f) {
                scale = 1.0f;
                heightDiff = (target.getHeight() - targetRect.height()) / 2;
                int widthDiff = (target.getWidth() - targetRect.width()) / 2;
                afterRect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
            } else {
                scale = target.getScaleX();
                afterRect = targetRect;
            }
            float horizontalDiff = ((float)target.getWidth() * scale - (float)target.getWidth()) / 2.0f;
            if (this.restrictionRect.left < (float)afterRect.left) {
                this.cancel();
                ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(this.restrictionRect.left + horizontalDiff);
            } else if ((float)afterRect.right < this.restrictionRect.right) {
                this.cancel();
                ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(this.restrictionRect.right - (float)target.getWidth() - horizontalDiff);
            }
        }
    }

    @Override
    public void fling(float velocity) {
        this.isFlinging = true;
        this.cancel();
        this.fling.addUpdateListener(this.updateListener);
        this.fling.addEndListener(this.endListener);
        this.fling.setStartVelocity(velocity).start();
    }

    @Override
    public boolean isNotFlinging() {
        return !this.isFlinging;
    }

    private void cancel() {
        this.animator.cancel();
        this.spring.cancel();
        this.fling.cancel();
        this.fling.removeUpdateListener(this.updateListener);
        this.fling.removeEndListener(this.endListener);
        this.isFlinging = false;
    }
}

