/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.takusemba.cropme.ActionDetector;
import com.takusemba.cropme.ActionListener;
import com.takusemba.cropme.CropImageView;
import com.takusemba.cropme.CropOverlayView;
import com.takusemba.cropme.Croppable;
import com.takusemba.cropme.HorizontalMoveAnimatorImpl;
import com.takusemba.cropme.MoveAnimator;
import com.takusemba.cropme.OnCropListener;
import com.takusemba.cropme.R;
import com.takusemba.cropme.ScaleAnimator;
import com.takusemba.cropme.ScaleAnimatorImpl;
import com.takusemba.cropme.VerticalMoveAnimatorImpl;

public class CropView
extends FrameLayout
implements Croppable {
    private static final int DEFAULT_BASE = 1;
    private static final int DEFAULT_PBASE = 1;
    private static final int MIN_PERCENT = 0;
    private static final int MAX_PERCENT = 1;
    private static final float DEFAULT_PERCENT_WIDTH = 0.8f;
    private static final float DEFAULT_PERCENT_HEIGHT = 0.8f;
    private static final int DEFAULT_MAX_SCALE = 2;
    private static final int MIN_SCALE = 1;
    private static final int MAX_SCALE = 5;
    private static final float DEFAULT_BACKGROUND_ALPHA = 0.8f;
    private static final float COLOR_DENSITY = 255.0f;
    private static final boolean DEFAULT_WITH_BORDER = true;
    private MoveAnimator horizontalAnimator;
    private MoveAnimator verticalAnimator;
    private ScaleAnimator scaleAnimator;
    private ActionDetector actionDetector;
    private float percentWidth;
    private float percentHeight;
    private int maxScale;
    private RectF restriction;
    private int backgroundAlpha;
    private boolean withBorder;

    public CropView(@NonNull Context context) {
        this(context, null);
    }

    public CropView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CropView);
        this.percentWidth = a.getFraction(R.styleable.CropView_cropme_result_width, 1, 1, 0.8f);
        if (this.percentWidth < 0.0f || 1.0f < this.percentWidth) {
            throw new IllegalArgumentException("sr_result_width must be set from 0% to 100%");
        }
        this.percentHeight = a.getFraction(R.styleable.CropView_cropme_result_height, 1, 1, 0.8f);
        if (this.percentHeight < 0.0f || 1.0f < this.percentHeight) {
            throw new IllegalArgumentException("sr_result_height must be set from 0% to 100%");
        }
        this.maxScale = a.getInt(R.styleable.CropView_cropme_max_scale, 2);
        if (this.maxScale < 1 || 5 < this.maxScale) {
            throw new IllegalArgumentException("sr_max_scale must be set from 1 to 5");
        }
        this.backgroundAlpha = (int)(a.getFraction(R.styleable.CropView_cropme_background_alpha, 1, 1, 0.8f) * 255.0f);
        if (this.percentWidth < 0.0f || 1.0f < this.percentWidth) {
            throw new IllegalArgumentException("sr_background_alpha must be set from 0% to 100%");
        }
        this.withBorder = a.getBoolean(R.styleable.CropView_cropme_with_border, true);
        a.recycle();
        this.init();
    }

    private void init() {
        this.startActionDetector();
        this.addLayouts();
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                CropImageView target = (CropImageView)CropView.this.findViewById(R.id.cropme_image_view);
                CropOverlayView overlayView = (CropOverlayView)CropView.this.findViewById(R.id.cropme_overlay);
                float resultWidth = (float)CropView.this.getWidth() * CropView.this.percentWidth;
                float resultHeight = (float)CropView.this.getHeight() * CropView.this.percentHeight;
                CropView.this.restriction = new RectF(((float)CropView.this.getWidth() - resultWidth) / 2.0f, ((float)CropView.this.getHeight() - resultHeight) / 2.0f, ((float)CropView.this.getWidth() + resultWidth) / 2.0f, ((float)CropView.this.getHeight() + resultHeight) / 2.0f);
                CropView.this.horizontalAnimator = new HorizontalMoveAnimatorImpl((View)target, CropView.this.restriction, CropView.this.maxScale);
                CropView.this.verticalAnimator = new VerticalMoveAnimatorImpl((View)target, CropView.this.restriction, CropView.this.maxScale);
                CropView.this.scaleAnimator = new ScaleAnimatorImpl((View)target, CropView.this.maxScale);
                target.setResultRect(CropView.this.restriction);
                overlayView.setAttrs(CropView.this.restriction, CropView.this.backgroundAlpha, CropView.this.withBorder);
                CropView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                return true;
            }
        });
    }

    private void startActionDetector() {
        this.actionDetector = new ActionDetector(this.getContext(), new ActionListener(){

            @Override
            public void onScaled(float scale) {
                CropView.this.scaleAnimator.scale(scale);
            }

            @Override
            public void onScaleEnded() {
                CropView.this.scaleAnimator.reScaleIfNeeded();
            }

            @Override
            public void onMoved(float dx, float dy) {
                CropView.this.horizontalAnimator.move(dx);
                CropView.this.verticalAnimator.move(dy);
            }

            @Override
            public void onFlinged(float velocityX, float velocityY) {
                CropView.this.horizontalAnimator.fling(velocityX);
                CropView.this.verticalAnimator.fling(velocityY);
            }

            @Override
            public void onMoveEnded() {
                if (CropView.this.horizontalAnimator.isNotFlinging()) {
                    CropView.this.horizontalAnimator.reMoveIfNeeded(0.0f);
                }
                if (CropView.this.verticalAnimator.isNotFlinging()) {
                    CropView.this.verticalAnimator.reMoveIfNeeded(0.0f);
                }
            }
        });
        this.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                CropView.this.actionDetector.detectAction(event);
                return true;
            }
        });
    }

    private void addLayouts() {
        CropImageView imageView = new CropImageView(this.getContext());
        imageView.setId(R.id.cropme_image_view);
        FrameLayout.LayoutParams imageParams = new FrameLayout.LayoutParams(-2, -2, 17);
        imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        imageView.setAdjustViewBounds(true);
        this.addView((View)imageView, (ViewGroup.LayoutParams)imageParams);
        CropOverlayView overlayView = new CropOverlayView(this.getContext());
        overlayView.setId(R.id.cropme_overlay);
        FrameLayout.LayoutParams overlayParams = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)overlayView, (ViewGroup.LayoutParams)overlayParams);
    }

    @Override
    public void setUri(Uri uri) {
        ImageView image = (ImageView)this.findViewById(R.id.cropme_image_view);
        image.setImageURI(uri);
        image.requestLayout();
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        ImageView image = (ImageView)this.findViewById(R.id.cropme_image_view);
        image.setImageBitmap(bitmap);
        image.requestLayout();
    }

    @Override
    public void crop(OnCropListener listener) {
        CropImageView target = (CropImageView)this.findViewById(R.id.cropme_image_view);
        Rect targetRect = new Rect();
        target.getHitRect(targetRect);
        Bitmap bitmap = ((BitmapDrawable)target.getDrawable()).getBitmap();
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)targetRect.width(), (int)targetRect.height(), (boolean)false);
        int leftOffset = (int)(this.restriction.left - (float)targetRect.left);
        int topOffset = (int)(this.restriction.top - (float)targetRect.top);
        int rightOffset = (int)((float)targetRect.right - this.restriction.right);
        int bottomOffset = (int)((float)targetRect.bottom - this.restriction.bottom);
        int width = (int)this.restriction.width();
        int height = (int)this.restriction.height();
        if (leftOffset < 0) {
            width += leftOffset;
            leftOffset = 0;
        }
        if (topOffset < 0) {
            height += topOffset;
            topOffset = 0;
        }
        if (rightOffset < 0) {
            width += rightOffset;
        }
        if (bottomOffset < 0) {
            height += bottomOffset;
        }
        if (width < 0 || height < 0) {
            listener.onFailure();
            return;
        }
        Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)leftOffset, (int)topOffset, (int)width, (int)height);
        if (result != null) {
            listener.onSuccess(result);
        } else {
            listener.onFailure();
        }
    }
}

