/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.takusemba.cropme.R;

class CropOverlayView
extends FrameLayout {
    private static final int BORDER_WIDTH = 5;
    private final Paint background = new Paint();
    private final Paint border = new Paint();
    private final Paint cropPaint = new Paint();
    private RectF resultRect;
    private int backgroundAlpha;
    private boolean withBorder;

    public CropOverlayView(@NonNull Context context) {
        this(context, null);
    }

    public CropOverlayView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropOverlayView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
        this.cropPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.border.setStrokeWidth(5.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.background.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170444));
        this.background.setAlpha(this.backgroundAlpha);
        this.border.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.light_white));
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.background);
        canvas.drawRect(this.resultRect, this.cropPaint);
        if (this.withBorder) {
            float borderHeight = this.resultRect.height() / 3.0f;
            canvas.drawLine(this.resultRect.left, this.resultRect.top, this.resultRect.right, this.resultRect.top, this.border);
            canvas.drawLine(this.resultRect.left, this.resultRect.top + borderHeight, this.resultRect.right, this.resultRect.top + borderHeight, this.border);
            canvas.drawLine(this.resultRect.left, this.resultRect.top + borderHeight * 2.0f, this.resultRect.right, this.resultRect.top + borderHeight * 2.0f, this.border);
            canvas.drawLine(this.resultRect.left, this.resultRect.bottom, this.resultRect.right, this.resultRect.bottom, this.border);
            float borderWidth = this.resultRect.width() / 3.0f;
            canvas.drawLine(this.resultRect.left, this.resultRect.top, this.resultRect.left, this.resultRect.bottom, this.border);
            canvas.drawLine(this.resultRect.left + borderWidth, this.resultRect.top, this.resultRect.left + borderWidth, this.resultRect.bottom, this.border);
            canvas.drawLine(this.resultRect.left + borderWidth * 2.0f, this.resultRect.top, this.resultRect.left + borderWidth * 2.0f, this.resultRect.bottom, this.border);
            canvas.drawLine(this.resultRect.right, this.resultRect.top, this.resultRect.right, this.resultRect.bottom, this.border);
        }
    }

    void setAttrs(RectF resultRect, int backgroundAlpha, boolean withBorder) {
        this.resultRect = resultRect;
        this.backgroundAlpha = backgroundAlpha;
        this.withBorder = withBorder;
    }
}

