/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.content.Context;
import android.graphics.RectF;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;

class CropImageView
extends AppCompatImageView {
    private RectF resultRect;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float height = this.getMeasuredHeight();
        float width = this.getMeasuredWidth();
        float widthScale = this.resultRect != null ? this.resultRect.width() / width : 1.0f;
        float heightScale = this.resultRect != null ? this.resultRect.height() / height : 1.0f;
        float scale = Math.max(widthScale, heightScale);
        this.setMeasuredDimension((int)(width * scale), (int)(height * scale));
    }

    void setResultRect(RectF resultRect) {
        this.resultRect = resultRect;
    }
}

