/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.takusemba.cropme.ActionListener;

class ActionDetector {
    private ActionListener listener;
    private GestureDetectorCompat gestureDetectorCompat;
    private ScaleGestureDetector scaleGestureDetector;
    private GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return true;
        }

        public boolean onScroll(MotionEvent initialEvent, MotionEvent currentEvent, float dx, float dy) {
            ActionDetector.this.listener.onMoved(-dx, -dy);
            return true;
        }

        public void onLongPress(MotionEvent e) {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            ActionDetector.this.listener.onFlinged(velocityX, velocityY);
            return true;
        }
    };
    private ScaleGestureDetector.SimpleOnScaleGestureListener simpleScaleListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return super.onScaleBegin(detector);
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            super.onScaleEnd(detector);
            ActionDetector.this.listener.onScaleEnded();
        }

        public boolean onScale(ScaleGestureDetector detector) {
            ActionDetector.this.listener.onScaled(detector.getScaleFactor());
            return true;
        }
    };

    ActionDetector(Context context, ActionListener actionListener) {
        this.listener = actionListener;
        this.gestureDetectorCompat = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.simpleOnGestureListener);
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this.simpleScaleListener);
    }

    void detectAction(MotionEvent event) {
        if (this.gestureDetectorCompat == null) {
            throw new IllegalStateException("GestureDetectorCompat must not be null");
        }
        this.gestureDetectorCompat.onTouchEvent(event);
        this.scaleGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 1: {
                this.listener.onMoveEnded();
            }
        }
    }
}

