/*
 * Decompiled with CFR 0.152.
 */
package com.github.takahirom.hyperion.plugin.simpleitem;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.takahirom.hyperion.plugin.simpleitem.SimpleItem;
import java.util.ArrayList;
import java.util.List;
import takahirom.github.com.hyperion_simple_item.R;

class SimpleItemListAdapter
extends RecyclerView.Adapter<SimpleItemViewHolder> {
    private LayoutInflater layoutInflater;
    @NonNull
    private List<SimpleItem> items = new ArrayList<SimpleItem>();

    SimpleItemListAdapter(LayoutInflater layoutInflater) {
        this.layoutInflater = layoutInflater;
    }

    @NonNull
    public SimpleItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new SimpleItemViewHolder(this.layoutInflater.inflate(R.layout.layout_simple_item, parent, false));
    }

    public void onBindViewHolder(@NonNull SimpleItemViewHolder holder, int position) {
        SimpleItem item = this.items.get(position);
        holder.title.setText((CharSequence)item.title);
        holder.text.setText((CharSequence)item.text);
        holder.text.setVisibility(item.text == null ? 8 : 0);
        holder.image.setImageResource(item.image);
        holder.image.setVisibility(item.image == 0 ? 8 : 0);
        holder.itemView.setOnClickListener(item.clickListener);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void submitList(List<SimpleItem> items) {
        this.items = items;
        this.notifyDataSetChanged();
    }

    class SimpleItemViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView title;
        private final TextView text;
        private final ImageView image;

        SimpleItemViewHolder(View itemView) {
            super(itemView);
            this.title = (TextView)itemView.findViewById(R.id.title);
            this.text = (TextView)itemView.findViewById(R.id.text);
            this.image = (ImageView)itemView.findViewById(R.id.image);
        }
    }
}

