/*
 * Decompiled with CFR 0.152.
 */
package com.github.takahirom.hyperion.plugin.simpleitem;

import android.support.annotation.NonNull;
import android.support.v7.recyclerview.extensions.ListAdapter;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.takahirom.hyperion.plugin.simpleitem.SimpleItem;
import takahirom.github.com.hyperion_simple_item.R;

class SimpleItemListAdapter
extends ListAdapter<SimpleItem, SimpleItemViewHolder> {
    private static final DiffUtil.ItemCallback<SimpleItem> DIFF_CALLBACK = new DiffUtil.ItemCallback<SimpleItem>(){

        public boolean areItemsTheSame(@NonNull SimpleItem oldUser, @NonNull SimpleItem newUser) {
            return oldUser.equals(newUser);
        }

        public boolean areContentsTheSame(@NonNull SimpleItem oldUser, @NonNull SimpleItem newUser) {
            return oldUser.equals(newUser);
        }
    };
    private LayoutInflater layoutInflater;

    SimpleItemListAdapter(LayoutInflater layoutInflater) {
        super(DIFF_CALLBACK);
        this.layoutInflater = layoutInflater;
    }

    @NonNull
    public SimpleItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new SimpleItemViewHolder(this.layoutInflater.inflate(R.layout.layout_simple_item, parent, false));
    }

    public void onBindViewHolder(@NonNull SimpleItemViewHolder holder, int position) {
        SimpleItem item = (SimpleItem)this.getItem(position);
        holder.title.setText((CharSequence)item.title);
        holder.text.setText((CharSequence)item.text);
        holder.text.setVisibility(item.text == null ? 8 : 0);
        holder.image.setImageResource(item.image);
        holder.image.setVisibility(item.image == 0 ? 8 : 0);
        holder.itemView.setOnClickListener(item.clickListener);
    }

    class SimpleItemViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView title;
        private final TextView text;
        private final ImageView image;

        SimpleItemViewHolder(View itemView) {
            super(itemView);
            this.title = (TextView)itemView.findViewById(R.id.title);
            this.text = (TextView)itemView.findViewById(R.id.text);
            this.image = (ImageView)itemView.findViewById(R.id.image);
        }
    }
}

