/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.nammu;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.tajchert.nammu.PermissionCallback;
import pl.tajchert.nammu.PermissionListener;
import pl.tajchert.nammu.PermissionRequest;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\b\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010%J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\b\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010)J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$J+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020*2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\b\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010+J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020*2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004J\u0016\u00100\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0004J#\u00100\u001a\u00020-2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0004J\u000e\u00103\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u0010J\u0010\u00104\u001a\u00020-2\b\u0010&\u001a\u0004\u0018\u00010\u0004J)\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"2\u0006\u00107\u001a\u000208\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020\u001e2\b\u0010;\u001a\u0004\u0018\u00010<J\u0006\u0010=\u001a\u00020\u001eJ\u0016\u0010>\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010>\u001a\u00020-2\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010>\u001a\u00020-2\u0006\u0010'\u001a\u00020*2\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010?\u001a\u00020-2\u0006\u00107\u001a\u000208R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lpl/tajchert/nammu/Nammu;", "", "()V", "KEY_IGNORED_PERMISSIONS", "", "KEY_PREV_PERMISSIONS", "SYSTEM_ALERT_WINDOW_PERMISSION_REQ_CODE", "", "getSYSTEM_ALERT_WINDOW_PERMISSION_REQ_CODE", "()I", "TAG", "kotlin.jvm.PlatformType", "WRITE_SETTINGS_PERMISSION_REQ_CODE", "getWRITE_SETTINGS_PERMISSION_REQ_CODE", "context", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "grantedPermissions", "Ljava/util/ArrayList;", "getGrantedPermissions", "()Ljava/util/ArrayList;", "ignoredPermissions", "getIgnoredPermissions", "permissionRequests", "Lpl/tajchert/nammu/PermissionRequest;", "previousPermissions", "getPreviousPermissions", "sharedPreferences", "Landroid/content/SharedPreferences;", "askForPermission", "", "activity", "Landroid/app/Activity;", "permissions", "", "permissionCallback", "Lpl/tajchert/nammu/PermissionCallback;", "(Landroid/app/Activity;[Ljava/lang/String;Lpl/tajchert/nammu/PermissionCallback;)V", "permission", "fragment", "Landroid/app/Fragment;", "(Landroid/app/Fragment;[Ljava/lang/String;Lpl/tajchert/nammu/PermissionCallback;)V", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;Lpl/tajchert/nammu/PermissionCallback;)V", "checkPermission", "", "permissionName", "checkSpecialPermission", "hasPermission", "(Landroid/app/Activity;[Ljava/lang/String;)Z", "ignorePermission", "init", "isIgnoredPermission", "onRequestPermissionsResult", "requestCode", "grantResults", "", "(I[Ljava/lang/String;[I)V", "permissionCompare", "permissionListener", "Lpl/tajchert/nammu/PermissionListener;", "refreshMonitoredList", "shouldShowRequestPermissionRationale", "verifyPermissions", "nammu_release"})
public final class Nammu {
    private static final String TAG;
    private static WeakReference<Context> context;
    private static SharedPreferences sharedPreferences;
    private static final String KEY_PREV_PERMISSIONS = "previous_permissions";
    private static final String KEY_IGNORED_PERMISSIONS = "ignored_permissions";
    private static final ArrayList<PermissionRequest> permissionRequests;
    private static final int SYSTEM_ALERT_WINDOW_PERMISSION_REQ_CODE = 1971;
    private static final int WRITE_SETTINGS_PERMISSION_REQ_CODE = 1970;
    public static final Nammu INSTANCE;

    public final int getSYSTEM_ALERT_WINDOW_PERMISSION_REQ_CODE() {
        return SYSTEM_ALERT_WINDOW_PERMISSION_REQ_CODE;
    }

    public final int getWRITE_SETTINGS_PERMISSION_REQ_CODE() {
        return WRITE_SETTINGS_PERMISSION_REQ_CODE;
    }

    @NotNull
    public final ArrayList<String> getGrantedPermissions() {
        block12: {
            block11: {
                if (context == null) break block11;
                WeakReference<Context> weakReference = context;
                if (weakReference == null) {
                    Intrinsics.throwNpe();
                }
                if (weakReference.get() != null) break block12;
            }
            throw (Throwable)new RuntimeException("Must call init() earlier");
        }
        ArrayList<String> permissions = new ArrayList<String>();
        ArrayList<String> permissionsGranted = new ArrayList<String>();
        permissions.add("android.permission.ACCESS_FINE_LOCATION");
        permissions.add("android.permission.ACCESS_COARSE_LOCATION");
        permissions.add("android.permission.WRITE_CALENDAR");
        permissions.add("android.permission.READ_CALENDAR");
        permissions.add("android.permission.CAMERA");
        permissions.add("android.permission.WRITE_CONTACTS");
        permissions.add("android.permission.READ_CONTACTS");
        permissions.add("android.permission.GET_ACCOUNTS");
        permissions.add("android.permission.RECORD_AUDIO");
        permissions.add("android.permission.CALL_PHONE");
        permissions.add("android.permission.READ_PHONE_STATE");
        if (Build.VERSION.SDK_INT >= 16) {
            permissions.add("android.permission.READ_CALL_LOG");
        }
        if (Build.VERSION.SDK_INT >= 16) {
            permissions.add("android.permission.WRITE_CALL_LOG");
        }
        permissions.add("com.android.voicemail.permission.ADD_VOICEMAIL");
        permissions.add("android.permission.USE_SIP");
        permissions.add("android.permission.PROCESS_OUTGOING_CALLS");
        if (Build.VERSION.SDK_INT >= 20) {
            permissions.add("android.permission.BODY_SENSORS");
        }
        permissions.add("android.permission.SEND_SMS");
        permissions.add("android.permission.READ_SMS");
        permissions.add("android.permission.RECEIVE_SMS");
        permissions.add("android.permission.RECEIVE_WAP_PUSH");
        permissions.add("android.permission.RECEIVE_MMS");
        if (Build.VERSION.SDK_INT >= 16) {
            permissions.add("android.permission.READ_EXTERNAL_STORAGE");
        }
        permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        for (String permission : permissions) {
            WeakReference<Context> weakReference = context;
            if (weakReference == null) {
                Intrinsics.throwNpe();
            }
            Object t = weakReference.get();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            if (ContextCompat.checkSelfPermission((Context)((Context)t), (String)permission) != 0) continue;
            permissionsGranted.add(permission);
        }
        return permissionsGranted;
    }

    @NotNull
    public final ArrayList<String> getPreviousPermissions() {
        ArrayList<String> prevPermissions = new ArrayList<String>();
        SharedPreferences sharedPreferences = Nammu.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwNpe();
        }
        Set set = sharedPreferences.getStringSet(KEY_PREV_PERMISSIONS, (Set)new HashSet());
        if (set == null) {
            Intrinsics.throwNpe();
        }
        prevPermissions.addAll(set);
        return prevPermissions;
    }

    @NotNull
    public final ArrayList<String> getIgnoredPermissions() {
        ArrayList<String> ignoredPermissions = new ArrayList<String>();
        SharedPreferences sharedPreferences = Nammu.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwNpe();
        }
        Set set = sharedPreferences.getStringSet(KEY_IGNORED_PERMISSIONS, (Set)new HashSet());
        if (set == null) {
            Intrinsics.throwNpe();
        }
        ignoredPermissions.addAll(set);
        return ignoredPermissions;
    }

    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        sharedPreferences = context.getSharedPreferences("pl.tajchert.runtimepermissionhelper", 0);
        Nammu.context = new WeakReference<Context>(context);
    }

    public final boolean verifyPermissions(@NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public final boolean hasPermission(@NotNull Activity activity, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)((Context)activity), (String)permission) == 0;
    }

    public final boolean hasPermission(@Nullable Activity activity, @NotNull String[] permissions) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        for (String permission : permissions) {
            Activity activity2 = activity;
            if (activity2 == null) {
                Intrinsics.throwNpe();
            }
            if (ContextCompat.checkSelfPermission((Context)((Context)activity2), (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public final boolean shouldShowRequestPermissionRationale(@NotNull Activity activity, @NotNull String permissions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permissions);
    }

    public final boolean shouldShowRequestPermissionRationale(@NotNull androidx.fragment.app.Fragment fragment, @NotNull String permissions) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        return fragment.shouldShowRequestPermissionRationale(permissions);
    }

    public final boolean shouldShowRequestPermissionRationale(@NotNull Fragment fragment, @NotNull String permissions) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        return Build.VERSION.SDK_INT >= 23 ? fragment.shouldShowRequestPermissionRationale(permissions) : false;
    }

    public final void askForPermission(@NotNull Activity activity, @NotNull String permission, @NotNull PermissionCallback permissionCallback) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)permissionCallback, (String)"permissionCallback");
        this.askForPermission(activity, new String[]{permission}, permissionCallback);
    }

    public final void askForPermission(@NotNull Activity activity, @NotNull String[] permissions, @Nullable PermissionCallback permissionCallback) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        if (permissionCallback == null) {
            return;
        }
        if (this.hasPermission(activity, permissions)) {
            permissionCallback.permissionGranted();
            return;
        }
        PermissionRequest permissionRequest = new PermissionRequest(new ArrayList<String>((Collection)Arrays.asList(Arrays.copyOf(permissions, permissions.length))), permissionCallback);
        permissionRequests.add(permissionRequest);
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)permissionRequest.getRequestCode());
    }

    public final void askForPermission(@NotNull androidx.fragment.app.Fragment fragment, @NotNull String permission, @NotNull PermissionCallback permissionCallback) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)permissionCallback, (String)"permissionCallback");
        this.askForPermission(fragment, new String[]{permission}, permissionCallback);
    }

    public final void askForPermission(@NotNull Fragment fragment, @NotNull String permission, @NotNull PermissionCallback permissionCallback) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)permissionCallback, (String)"permissionCallback");
        this.askForPermission(fragment, new String[]{permission}, permissionCallback);
    }

    public final void askForPermission(@NotNull androidx.fragment.app.Fragment fragment, @NotNull String[] permissions, @Nullable PermissionCallback permissionCallback) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        if (permissionCallback == null) {
            return;
        }
        if (this.hasPermission((Activity)fragment.getActivity(), permissions)) {
            permissionCallback.permissionGranted();
            return;
        }
        PermissionRequest permissionRequest = new PermissionRequest(new ArrayList<String>((Collection)Arrays.asList(Arrays.copyOf(permissions, permissions.length))), permissionCallback);
        permissionRequests.add(permissionRequest);
        fragment.requestPermissions(permissions, permissionRequest.getRequestCode());
    }

    public final void askForPermission(@NotNull Fragment fragment, @NotNull String[] permissions, @Nullable PermissionCallback permissionCallback) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        if (permissionCallback == null) {
            return;
        }
        if (this.hasPermission(fragment.getActivity(), permissions)) {
            permissionCallback.permissionGranted();
            return;
        }
        PermissionRequest permissionRequest = new PermissionRequest(new ArrayList<String>((Collection)Arrays.asList(Arrays.copyOf(permissions, permissions.length))), permissionCallback);
        permissionRequests.add(permissionRequest);
        if (Build.VERSION.SDK_INT >= 23) {
            fragment.requestPermissions(permissions, permissionRequest.getRequestCode());
        }
    }

    public final void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        PermissionRequest requestResult = new PermissionRequest(requestCode);
        if (permissionRequests.contains(requestResult)) {
            PermissionRequest permissionRequest = permissionRequests.get(permissionRequests.indexOf(requestResult));
            Intrinsics.checkExpressionValueIsNotNull((Object)permissionRequest, (String)"permissionRequests[permi\u2026s.indexOf(requestResult)]");
            PermissionRequest permissionRequest2 = permissionRequest;
            if (this.verifyPermissions(grantResults)) {
                PermissionCallback permissionCallback = permissionRequest2.getPermissionCallback();
                if (permissionCallback == null) {
                    Intrinsics.throwNpe();
                }
                permissionCallback.permissionGranted();
            } else {
                PermissionCallback permissionCallback = permissionRequest2.getPermissionCallback();
                if (permissionCallback == null) {
                    Intrinsics.throwNpe();
                }
                permissionCallback.permissionRefused();
            }
            permissionRequests.remove(requestResult);
        }
        this.refreshMonitoredList();
    }

    public final void refreshMonitoredList() {
        ArrayList<String> permissions = this.getGrantedPermissions();
        HashSet set = new HashSet(permissions);
        SharedPreferences sharedPreferences = Nammu.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwNpe();
        }
        sharedPreferences.edit().putStringSet(KEY_PREV_PERMISSIONS, (Set)set).apply();
    }

    public final boolean isIgnoredPermission(@Nullable String permission) {
        if (permission == null) {
            return false;
        }
        return this.getIgnoredPermissions().contains(permission);
    }

    public final void ignorePermission(@NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (!this.isIgnoredPermission(permission)) {
            ArrayList<String> ignoredPermissions = this.getIgnoredPermissions();
            ignoredPermissions.add(permission);
            HashSet set = new HashSet();
            set.addAll(ignoredPermissions);
            SharedPreferences sharedPreferences = Nammu.sharedPreferences;
            if (sharedPreferences == null) {
                Intrinsics.throwNpe();
            }
            sharedPreferences.edit().putStringSet(KEY_IGNORED_PERMISSIONS, (Set)set).apply();
        }
    }

    public final void permissionCompare(@Nullable PermissionListener permissionListener) {
        if (context == null) {
            throw (Throwable)new RuntimeException("Before comparing permissions you need to call Nammu.init(context)");
        }
        ArrayList<String> previouslyGranted = this.getPreviousPermissions();
        ArrayList<String> currentPermissions = this.getGrantedPermissions();
        ArrayList<String> ignoredPermissions = this.getIgnoredPermissions();
        for (String string : ignoredPermissions) {
            Collection collection = previouslyGranted;
            boolean bl = false;
            if (!collection.isEmpty() && previouslyGranted.contains(string)) {
                previouslyGranted.remove(string);
            }
            collection = currentPermissions;
            bl = false;
            if (!(!collection.isEmpty()) || !currentPermissions.contains(string)) continue;
            currentPermissions.remove(string);
        }
        for (String string : currentPermissions) {
            if (previouslyGranted.contains(string)) {
                previouslyGranted.remove(string);
                continue;
            }
            if (permissionListener == null) continue;
            String string2 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"permission");
            permissionListener.permissionsChanged(string2);
            permissionListener.permissionsGranted(string);
        }
        Collection collection = previouslyGranted;
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (String string : previouslyGranted) {
                if (permissionListener == null) continue;
                String string3 = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"permission");
                permissionListener.permissionsChanged(string3);
                permissionListener.permissionsRemoved(string);
            }
        }
        this.refreshMonitoredList();
    }

    public final boolean checkPermission(@NotNull String permissionName) {
        Intrinsics.checkParameterIsNotNull((Object)permissionName, (String)"permissionName");
        if (context == null) {
            throw (Throwable)new RuntimeException("Before comparing permissions you need to call Nammu.init(context)");
        }
        WeakReference<Context> weakReference = context;
        if (weakReference == null) {
            Intrinsics.throwNpe();
        }
        Object t = weakReference.get();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return ContextCompat.checkSelfPermission((Context)((Context)t), (String)permissionName) == 0;
    }

    public final boolean checkSpecialPermission(@NotNull String permissionName) {
        Intrinsics.checkParameterIsNotNull((Object)permissionName, (String)"permissionName");
        if (context == null) {
            throw (Throwable)new RuntimeException("Before comparing permissions you need to call PermissionManager.init(context)");
        }
        if (Build.VERSION.SDK_INT < 23) {
            Log.e((String)"Nammu", (String)"Special permission cannot be checked as Android version is below Android 6.0");
            return false;
        }
        switch (permissionName) {
            case "android.permission.SYSTEM_ALERT_WINDOW": {
                if (Build.VERSION.SDK_INT < 23) break;
                WeakReference<Context> weakReference = context;
                if (weakReference == null) {
                    Intrinsics.throwNpe();
                }
                Object t = weakReference.get();
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                return Settings.canDrawOverlays((Context)((Context)t));
            }
            case "android.permission.WRITE_SETTINGS": {
                if (Build.VERSION.SDK_INT < 23) break;
                WeakReference<Context> weakReference = context;
                if (weakReference == null) {
                    Intrinsics.throwNpe();
                }
                Object t = weakReference.get();
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                return Settings.System.canWrite((Context)((Context)t));
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private Nammu() {
    }

    static {
        Nammu nammu;
        INSTANCE = nammu = new Nammu();
        TAG = Nammu.class.getSimpleName();
        KEY_PREV_PERMISSIONS = KEY_PREV_PERMISSIONS;
        KEY_IGNORED_PERMISSIONS = KEY_IGNORED_PERMISSIONS;
        permissionRequests = new ArrayList();
        SYSTEM_ALERT_WINDOW_PERMISSION_REQ_CODE = 1971;
        WRITE_SETTINGS_PERMISSION_REQ_CODE = 1970;
    }
}

