/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.nammu;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import pl.tajchert.nammu.PermissionCallback;
import pl.tajchert.nammu.PermissionListener;
import pl.tajchert.nammu.PermissionRequest;

public class Nammu {
    private static final String TAG = Nammu.class.getSimpleName();
    private static Context context;
    private static SharedPreferences sharedPreferences;
    private static final String KEY_PREV_PERMISSIONS = "previous_permissions";
    private static final String KEY_IGNORED_PERMISSIONS = "ignored_permissions";
    private static ArrayList<PermissionRequest> permissionRequests;

    public static void init(Context context) {
        sharedPreferences = context.getSharedPreferences("pl.tajchert.runtimepermissionhelper", 0);
        Nammu.context = context;
    }

    public static boolean verifyPermissions(int[] grantResults) {
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPermission(Activity activity, String permission2) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)permission2) == 0;
    }

    public static boolean hasPermission(Activity activity, String[] permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permissions) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permissions);
    }

    public static boolean shouldShowRequestPermissionRationale(Fragment fragment, String permissions) {
        return fragment.shouldShowRequestPermissionRationale(permissions);
    }

    public static void askForPermission(Activity activity, String permission2, PermissionCallback permissionCallback) {
        Nammu.askForPermission(activity, new String[]{permission2}, permissionCallback);
    }

    public static void askForPermission(Activity activity, String[] permissions, PermissionCallback permissionCallback) {
        if (permissionCallback == null) {
            return;
        }
        if (Nammu.hasPermission(activity, permissions)) {
            permissionCallback.permissionGranted();
            return;
        }
        PermissionRequest permissionRequest = new PermissionRequest(new ArrayList<String>(Arrays.asList(permissions)), permissionCallback);
        permissionRequests.add(permissionRequest);
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)permissionRequest.getRequestCode());
    }

    public static void askForPermission(Fragment fragment, String permission2, PermissionCallback permissionCallback) {
        Nammu.askForPermission(fragment, new String[]{permission2}, permissionCallback);
    }

    private static void askForPermission(Fragment fragment, String[] permissions, PermissionCallback permissionCallback) {
        if (permissionCallback == null) {
            return;
        }
        if (Nammu.hasPermission((Activity)fragment.getActivity(), permissions)) {
            permissionCallback.permissionGranted();
            return;
        }
        PermissionRequest permissionRequest = new PermissionRequest(new ArrayList<String>(Arrays.asList(permissions)), permissionCallback);
        permissionRequests.add(permissionRequest);
        fragment.requestPermissions(permissions, permissionRequest.getRequestCode());
    }

    public static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        PermissionRequest requestResult = new PermissionRequest(requestCode);
        if (permissionRequests.contains(requestResult)) {
            PermissionRequest permissionRequest = permissionRequests.get(permissionRequests.indexOf(requestResult));
            if (Nammu.verifyPermissions(grantResults)) {
                permissionRequest.getPermissionCallback().permissionGranted();
            } else {
                permissionRequest.getPermissionCallback().permissionRefused();
            }
            permissionRequests.remove(requestResult);
        }
        Nammu.refreshMonitoredList();
    }

    public static ArrayList<String> getGrantedPermissions() {
        if (context == null) {
            throw new RuntimeException("Must call init() earlier");
        }
        ArrayList<String> permissions = new ArrayList<String>();
        ArrayList<String> permissionsGranted = new ArrayList<String>();
        permissions.add("android.permission.ACCESS_FINE_LOCATION");
        permissions.add("android.permission.ACCESS_COARSE_LOCATION");
        permissions.add("android.permission.WRITE_CALENDAR");
        permissions.add("android.permission.READ_CALENDAR");
        permissions.add("android.permission.CAMERA");
        permissions.add("android.permission.WRITE_CONTACTS");
        permissions.add("android.permission.READ_CONTACTS");
        permissions.add("android.permission.GET_ACCOUNTS");
        permissions.add("android.permission.RECORD_AUDIO");
        permissions.add("android.permission.CALL_PHONE");
        permissions.add("android.permission.READ_PHONE_STATE");
        if (Build.VERSION.SDK_INT >= 16) {
            permissions.add("android.permission.READ_CALL_LOG");
        }
        if (Build.VERSION.SDK_INT >= 16) {
            permissions.add("android.permission.WRITE_CALL_LOG");
        }
        permissions.add("com.android.voicemail.permission.ADD_VOICEMAIL");
        permissions.add("android.permission.USE_SIP");
        permissions.add("android.permission.PROCESS_OUTGOING_CALLS");
        if (Build.VERSION.SDK_INT >= 20) {
            permissions.add("android.permission.BODY_SENSORS");
        }
        permissions.add("android.permission.SEND_SMS");
        permissions.add("android.permission.READ_SMS");
        permissions.add("android.permission.RECEIVE_SMS");
        permissions.add("android.permission.RECEIVE_WAP_PUSH");
        permissions.add("android.permission.RECEIVE_MMS");
        if (Build.VERSION.SDK_INT >= 16) {
            permissions.add("android.permission.READ_EXTERNAL_STORAGE");
        }
        permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) != 0) continue;
            permissionsGranted.add(permission2);
        }
        return permissionsGranted;
    }

    public static void refreshMonitoredList() {
        ArrayList<String> permissions = Nammu.getGrantedPermissions();
        HashSet<String> set = new HashSet<String>(permissions);
        sharedPreferences.edit().putStringSet(KEY_PREV_PERMISSIONS, set).apply();
    }

    public static ArrayList<String> getPreviousPermissions() {
        ArrayList<String> prevPermissions = new ArrayList<String>();
        prevPermissions.addAll(sharedPreferences.getStringSet(KEY_PREV_PERMISSIONS, new HashSet()));
        return prevPermissions;
    }

    public static ArrayList<String> getIgnoredPermissions() {
        ArrayList<String> ignoredPermissions = new ArrayList<String>();
        ignoredPermissions.addAll(sharedPreferences.getStringSet(KEY_IGNORED_PERMISSIONS, new HashSet()));
        return ignoredPermissions;
    }

    public static boolean isIgnoredPermission(String permission2) {
        if (permission2 == null) {
            return false;
        }
        return Nammu.getIgnoredPermissions().contains(permission2);
    }

    public static void ignorePermission(String permission2) {
        if (!Nammu.isIgnoredPermission(permission2)) {
            ArrayList<String> ignoredPermissions = Nammu.getIgnoredPermissions();
            ignoredPermissions.add(permission2);
            HashSet<String> set = new HashSet<String>();
            set.addAll(ignoredPermissions);
            sharedPreferences.edit().putStringSet(KEY_IGNORED_PERMISSIONS, set).apply();
        }
    }

    public static void permissionCompare(PermissionListener permissionListener) {
        if (context == null) {
            throw new RuntimeException("Before comparing permissions you need to call Nammu.init(context)");
        }
        ArrayList<String> previouslyGranted = Nammu.getPreviousPermissions();
        ArrayList<String> currentPermissions = Nammu.getGrantedPermissions();
        ArrayList<String> ignoredPermissions = Nammu.getIgnoredPermissions();
        for (String permission2 : ignoredPermissions) {
            if (previouslyGranted != null && !previouslyGranted.isEmpty() && previouslyGranted.contains(permission2)) {
                previouslyGranted.remove(permission2);
            }
            if (currentPermissions == null || currentPermissions.isEmpty() || !currentPermissions.contains(permission2)) continue;
            currentPermissions.remove(permission2);
        }
        for (String permission2 : currentPermissions) {
            if (previouslyGranted.contains(permission2)) {
                previouslyGranted.remove(permission2);
                continue;
            }
            if (permissionListener == null) continue;
            permissionListener.permissionsChanged(permission2);
            permissionListener.permissionsGranted(permission2);
        }
        if (previouslyGranted != null && !previouslyGranted.isEmpty()) {
            for (String permission2 : previouslyGranted) {
                if (permissionListener == null) continue;
                permissionListener.permissionsChanged(permission2);
                permissionListener.permissionsRemoved(permission2);
            }
        }
        Nammu.refreshMonitoredList();
    }

    public static boolean checkPermission(String permissionName) {
        if (context == null) {
            throw new RuntimeException("Before comparing permissions you need to call Nammu.init(context)");
        }
        return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permissionName);
    }

    static {
        permissionRequests = new ArrayList();
    }
}

