/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.houston;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import androidx.core.app.NotificationCompat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.tajchert.houston.HoustonLandReceiver;
import pl.tajchert.houston.NotificationCategory;
import pl.tajchert.houston.NotificationWrapper;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 02\u00020\u0001:\u00010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\u001e\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020!J\u000e\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001dJ\u0016\u0010$\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u001e\u0010$\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010'\u001a\u00020!J\u0018\u0010(\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001dH\u0016J\u0006\u0010*\u001a\u00020!J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010,\u001a\u00020!J\u000e\u0010-\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u0010R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lpl/tajchert/houston/Houston;", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;Landroid/content/Context;)V", "notificationManager", "Landroid/app/NotificationManager;", "(Landroid/content/SharedPreferences;Landroid/app/NotificationManager;)V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "<set-?>", "Ljava/util/ArrayList;", "Lpl/tajchert/houston/NotificationWrapper;", "notifications", "getNotifications", "()Ljava/util/ArrayList;", "addDismissListener", "Landroid/app/Notification$Builder;", "builder", "id", "", "Landroidx/core/app/NotificationCompat$Builder;", "createNotificationWrapper", "getNotification", "categoryName", "", "notificationCategory", "Lpl/tajchert/houston/NotificationCategory;", "land", "", "landAll", "category", "launch", "notification", "Landroid/app/Notification;", "onDestroy", "onSharedPreferenceChanged", "s", "persistNotifications", "readNotificationListFromStorage", "refreshList", "removeNotification", "saveNotification", "notificationWrapper", "Companion", "library_release"})
public final class Houston
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private final Gson gson;
    @NotNull
    private ArrayList<NotificationWrapper> notifications;
    private final SharedPreferences sharedPreferences;
    private final NotificationManager notificationManager;
    private static final String TAG;
    private static final String KEY_STORED = "houston_all_notifications_storage";
    public static final Companion Companion;

    @NotNull
    public final ArrayList<NotificationWrapper> getNotifications() {
        return this.notifications;
    }

    private final ArrayList<NotificationWrapper> readNotificationListFromStorage(SharedPreferences sharedPreferences) {
        ArrayList notificationFromStorage = null;
        try {
            notificationFromStorage = (ArrayList)this.gson.fromJson(this.sharedPreferences.getString(KEY_STORED, ""), new TypeToken<List<? extends NotificationWrapper>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            sharedPreferences.edit().remove(KEY_STORED).apply();
        }
        if (notificationFromStorage == null) {
            notificationFromStorage = new ArrayList();
        }
        return notificationFromStorage;
    }

    public final void saveNotification(@NotNull NotificationWrapper notificationWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)notificationWrapper, (String)"notificationWrapper");
        if (this.notifications.contains(notificationWrapper)) {
            this.notifications.remove(notificationWrapper);
        }
        this.notifications.add(notificationWrapper);
        this.persistNotifications();
    }

    public final void removeNotification(int id) {
        NotificationWrapper notificationWrapper = this.getNotification(id);
        if (notificationWrapper != null) {
            this.notifications.remove(notificationWrapper);
        }
        this.persistNotifications();
    }

    @Nullable
    public final NotificationWrapper getNotification(int id) {
        for (NotificationWrapper notificationWrapper : this.notifications) {
            if (notificationWrapper.getId() != id) continue;
            return notificationWrapper;
        }
        return null;
    }

    @NotNull
    public final ArrayList<NotificationWrapper> getNotifications(@NotNull String categoryName) {
        Intrinsics.checkParameterIsNotNull((Object)categoryName, (String)"categoryName");
        ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>();
        for (NotificationWrapper notificationWrapper : this.notifications) {
            if (notificationWrapper.getCategory() == null) continue;
            NotificationCategory notificationCategory = notificationWrapper.getCategory();
            if (notificationCategory == null) {
                Intrinsics.throwNpe();
            }
            if (!Intrinsics.areEqual((Object)categoryName, (Object)notificationCategory.getTitle())) continue;
            notificationWrappers.add(notificationWrapper);
        }
        return notificationWrappers;
    }

    @NotNull
    public final ArrayList<NotificationWrapper> getNotifications(@NotNull NotificationCategory notificationCategory) {
        Intrinsics.checkParameterIsNotNull((Object)notificationCategory, (String)"notificationCategory");
        ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>();
        for (NotificationWrapper notificationWrapper : this.notifications) {
            if (notificationWrapper.getCategory() == null || !Intrinsics.areEqual((Object)notificationWrapper.getCategory(), (Object)notificationCategory)) continue;
            notificationWrappers.add(notificationWrapper);
        }
        return notificationWrappers;
    }

    public final void persistNotifications() {
        this.sharedPreferences.edit().putString(KEY_STORED, this.gson.toJson(this.notifications)).apply();
    }

    private final NotificationWrapper createNotificationWrapper(int id) {
        NotificationWrapper notificationWrapper = new NotificationWrapper();
        notificationWrapper.setId(id);
        notificationWrapper.setShowTime(System.currentTimeMillis());
        return notificationWrapper;
    }

    @NotNull
    public final Notification.Builder addDismissListener(@NotNull Notification.Builder builder, int id, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent(context, HoustonLandReceiver.class);
        Bundle intentExtras = new Bundle();
        intentExtras.putInt(HoustonLandReceiver.Companion.getNOTIF_ID(), id);
        intent.putExtras(intentExtras);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)id, (Intent)intent, (int)0x8000000);
        builder.setDeleteIntent(pendingIntent);
        return builder;
    }

    @NotNull
    public final NotificationCompat.Builder addDismissListener(@NotNull NotificationCompat.Builder builder, int id, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent(context, HoustonLandReceiver.class);
        Bundle intentExtras = new Bundle();
        intentExtras.putInt(HoustonLandReceiver.Companion.getNOTIF_ID(), id);
        intent.putExtras(intentExtras);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)id, (Intent)intent, (int)0x8000000);
        builder.setDeleteIntent(pendingIntent);
        return builder;
    }

    public final void launch(int id, @NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        this.notificationManager.notify(id, notification);
        this.saveNotification(this.createNotificationWrapper(id));
    }

    public final void launch(int id, @NotNull Notification notification, @NotNull String category) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        this.launch(id, notification);
        NotificationWrapper notificationWrapper = this.createNotificationWrapper(id);
        notificationWrapper.setCategory(new NotificationCategory(category));
        this.saveNotification(notificationWrapper);
    }

    public final void refreshList() {
        if (Build.VERSION.SDK_INT >= 23) {
            StatusBarNotification[] activeNotifications = this.notificationManager.getActiveNotifications();
            if (activeNotifications != null) {
                ArrayList notificationWrappers = new ArrayList(this.notifications);
                StatusBarNotification[] statusBarNotificationArray = activeNotifications;
                int n = statusBarNotificationArray.length;
                for (int i = 0; i < n; ++i) {
                    StatusBarNotification notif;
                    StatusBarNotification statusBarNotification = notif = statusBarNotificationArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusBarNotification, (String)"notif");
                    NotificationWrapper notificationWrapper = this.getNotification(statusBarNotification.getId());
                    if (notificationWrapper == null) continue;
                    notificationWrappers.remove(notificationWrapper);
                }
                for (NotificationWrapper notificationWrapper : notificationWrappers) {
                    this.land(notificationWrapper.getId());
                }
            } else {
                this.landAll();
            }
        }
    }

    public final void land(int id) {
        this.notificationManager.cancel(id);
        NotificationWrapper notificationWrapper = this.getNotification(id);
        Collection collection = this.notifications;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(notificationWrapper);
        this.persistNotifications();
    }

    public final void landAll(@NotNull String category) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        ArrayList<NotificationWrapper> notifications = this.getNotifications(category);
        for (NotificationWrapper notificationWrapper : notifications) {
            this.notificationManager.cancel(notificationWrapper.getId());
            this.notifications.remove(notificationWrapper);
        }
        this.persistNotifications();
    }

    public final void landAll() {
        this.notificationManager.cancelAll();
        this.notifications.clear();
        this.persistNotifications();
    }

    public void onSharedPreferenceChanged(@NotNull SharedPreferences sharedPreferences, @NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (Intrinsics.areEqual((Object)KEY_STORED, (Object)s)) {
            this.notifications = this.readNotificationListFromStorage(sharedPreferences);
        }
    }

    public final void onDestroy() {
        this.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public Houston(@NotNull SharedPreferences sharedPreferences, @NotNull NotificationManager notificationManager) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkParameterIsNotNull((Object)notificationManager, (String)"notificationManager");
        this.sharedPreferences = sharedPreferences;
        this.notificationManager = notificationManager;
        this.gson = new GsonBuilder().create();
        this.notifications = new ArrayList();
        this.notifications = this.readNotificationListFromStorage(this.sharedPreferences);
        this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public Houston(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        SharedPreferences sharedPreferences = context.getSharedPreferences(context2.getPackageName(), 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ackageName, MODE_PRIVATE)");
        this(sharedPreferences, context);
    }

    public Houston(@NotNull SharedPreferences sharedPreferences, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        this(sharedPreferences, (NotificationManager)object);
    }

    static {
        Companion = new Companion(null);
        TAG = Houston.class.getCanonicalName();
        KEY_STORED = KEY_STORED;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lpl/tajchert/houston/Houston$Companion;", "", "()V", "KEY_STORED", "", "TAG", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

