/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.houston;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import pl.tajchert.houston.HoustonLandReceiver;
import pl.tajchert.houston.NotificationCategory;
import pl.tajchert.houston.NotificationWrapper;

public class Houston
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String TAG = Houston.class.getCanonicalName();
    private SharedPreferences sharedPreferences;
    private NotificationManager notificationManager;
    private Gson gson = new GsonBuilder().create();
    private static final String KEY_STORED = "houston_all_notifications_storage";
    private ArrayList<NotificationWrapper> allNotifications = new ArrayList();

    public Houston(Context context) {
        this.sharedPreferences = context.getSharedPreferences(context.getApplicationContext().getPackageName(), 0);
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
        this.allNotifications = (ArrayList)this.gson.fromJson(this.sharedPreferences.getString(KEY_STORED, ""), new TypeToken<List<NotificationWrapper>>(){}.getType());
        if (this.allNotifications == null) {
            this.allNotifications = new ArrayList();
        }
        this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public Houston(SharedPreferences sharedPreferences, Context context) {
        this.sharedPreferences = sharedPreferences;
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
        this.allNotifications = (ArrayList)this.gson.fromJson(this.sharedPreferences.getString(KEY_STORED, ""), new TypeToken<List<NotificationWrapper>>(){}.getType());
        if (this.allNotifications == null) {
            this.allNotifications = new ArrayList();
        }
        this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public Houston(SharedPreferences sharedPreferences, NotificationManager notificationManager) {
        this.sharedPreferences = sharedPreferences;
        this.notificationManager = notificationManager;
        this.allNotifications = (ArrayList)this.gson.fromJson(this.sharedPreferences.getString(KEY_STORED, ""), new TypeToken<List<NotificationWrapper>>(){}.getType());
        if (this.allNotifications == null) {
            this.allNotifications = new ArrayList();
        }
        this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public void saveNotification(NotificationWrapper notificationWrapper) {
        if (this.allNotifications.contains(notificationWrapper)) {
            this.allNotifications.remove(notificationWrapper);
        }
        this.allNotifications.add(notificationWrapper);
        this.persistNotifications();
    }

    public void removeNotification(int id) {
        NotificationWrapper notificationWrapper = this.getNotification(id);
        if (notificationWrapper != null) {
            this.allNotifications.remove(notificationWrapper);
        }
        this.persistNotifications();
    }

    public NotificationWrapper getNotification(int id) {
        for (NotificationWrapper notificationWrapper : this.allNotifications) {
            if (notificationWrapper.id != id) continue;
            return notificationWrapper;
        }
        return null;
    }

    public ArrayList<NotificationWrapper> getNotifications(String categoryName) {
        ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>();
        for (NotificationWrapper notificationWrapper : this.allNotifications) {
            if (notificationWrapper.category == null || !categoryName.equals(notificationWrapper.category.title)) continue;
            notificationWrappers.add(notificationWrapper);
        }
        return notificationWrappers;
    }

    public ArrayList<NotificationWrapper> getNotifications(NotificationCategory notificationCategory) {
        ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>();
        for (NotificationWrapper notificationWrapper : this.allNotifications) {
            if (notificationWrapper.category == null || !notificationWrapper.category.equals(notificationCategory)) continue;
            notificationWrappers.add(notificationWrapper);
        }
        return notificationWrappers;
    }

    public ArrayList<NotificationWrapper> getNotifications() {
        return this.allNotifications;
    }

    public void persistNotifications() {
        this.sharedPreferences.edit().putString(KEY_STORED, this.gson.toJson(this.allNotifications)).apply();
    }

    @NonNull
    private NotificationWrapper createNotificationWrapper(int id) {
        NotificationWrapper notificationWrapper = new NotificationWrapper();
        notificationWrapper.id = id;
        notificationWrapper.showTime = System.currentTimeMillis();
        return notificationWrapper;
    }

    public Notification.Builder addDismissListener(Notification.Builder builder, int id, Context context) {
        Intent intent = new Intent(context, HoustonLandReceiver.class);
        Bundle intentYawnBackActionExtras = new Bundle();
        intentYawnBackActionExtras.putInt("notifId", id);
        intent.putExtras(intentYawnBackActionExtras);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)id, (Intent)intent, (int)0x8000000);
        builder.setDeleteIntent(pendingIntent);
        return builder;
    }

    public NotificationCompat.Builder addDismissListener(NotificationCompat.Builder builder, int id, Context context) {
        Intent intent = new Intent(context, HoustonLandReceiver.class);
        Bundle intentYawnBackActionExtras = new Bundle();
        intentYawnBackActionExtras.putInt("notifId", id);
        intent.putExtras(intentYawnBackActionExtras);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)id, (Intent)intent, (int)0x8000000);
        builder.setDeleteIntent(pendingIntent);
        return builder;
    }

    public void launch(int id, Notification notification) {
        this.notificationManager.notify(id, notification);
        this.saveNotification(this.createNotificationWrapper(id));
    }

    public void launch(int id, Notification notification, String category) {
        this.launch(id, notification);
        NotificationWrapper notificationWrapper = this.createNotificationWrapper(id);
        notificationWrapper.category = new NotificationCategory(category);
        this.saveNotification(notificationWrapper);
    }

    public void refreshList() {
        if (Build.VERSION.SDK_INT >= 23) {
            StatusBarNotification[] activeNotifications = this.notificationManager.getActiveNotifications();
            if (activeNotifications != null && activeNotifications.length > 0) {
                ArrayList<NotificationWrapper> notificationWrappers = new ArrayList<NotificationWrapper>(this.allNotifications);
                for (StatusBarNotification notif : activeNotifications) {
                    NotificationWrapper notificationWrapper = this.getNotification(notif.getId());
                    if (notificationWrapper == null || !notificationWrappers.contains(notificationWrapper)) continue;
                    notificationWrappers.remove(notificationWrapper);
                }
                if (notificationWrappers.size() > 0) {
                    for (NotificationWrapper notificationWrapper : notificationWrappers) {
                        this.land(notificationWrapper.id);
                    }
                }
            } else {
                this.landAll();
            }
        }
    }

    public void land(int id) {
        Log.d((String)TAG, (String)"Tranquility Base here. The Eagle has landed");
        this.notificationManager.cancel(id);
        NotificationWrapper notificationWrapper = this.getNotification(id);
        this.allNotifications.remove(notificationWrapper);
        this.persistNotifications();
    }

    public void landAll(String category) {
        Log.d((String)TAG, (String)"Tranquility Base here. The Eagles had landed");
        ArrayList<NotificationWrapper> notifications = this.getNotifications(category);
        for (NotificationWrapper notificationWrapper : notifications) {
            this.notificationManager.cancel(notificationWrapper.id);
            this.allNotifications.remove(notificationWrapper);
        }
        this.persistNotifications();
    }

    public void landAll() {
        Log.d((String)TAG, (String)"Tranquility Base here. All Eagles had landed");
        this.notificationManager.cancelAll();
        this.allNotifications.clear();
        this.persistNotifications();
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String s) {
        Log.d((String)TAG, (String)"onSharedPreferenceChanged: ");
        if (KEY_STORED.equals(s)) {
            Log.d((String)TAG, (String)"onSharedPreferenceChanged: ");
            this.allNotifications = (ArrayList)this.gson.fromJson(this.sharedPreferences.getString(KEY_STORED, ""), new TypeToken<List<NotificationWrapper>>(){}.getType());
        }
        Log.d((String)TAG, (String)"onSharedPreferenceChanged: ");
    }

    public void onDestroy() {
        this.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }
}

