/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class GsonTool {
    private static GsonTool instance = null;
    private Gson gson = this.getGson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GsonTool getInstance() {
        if (instance != null) return instance;
        Class<GsonTool> clazz = GsonTool.class;
        synchronized (GsonTool.class) {
            if (null != instance) return instance;
            instance = new GsonTool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

                public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
                    if (src == (double)src.longValue()) {
                        return new JsonPrimitive((Number)src.longValue());
                    }
                    return new JsonPrimitive((Number)src);
                }
            }).excludeFieldsWithModifiers(new int[]{16, 128, 8}).serializeNulls().create();
        }
        return this.gson;
    }

    public <T> T toObject(String json, Class<T> cls) {
        return (T)this.gson.fromJson(json, cls);
    }

    public <T> T toObject(String json, Type type) {
        return (T)this.gson.fromJson(json, type);
    }

    public String toJson(Object obj) {
        return this.gson.toJson(obj);
    }

    public Map toLongMap(String json) {
        Type type = new TypeToken<Map<String, Long>>(){}.getType();
        return (Map)this.gson.fromJson(json, type);
    }
}

