/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.utils;

import com.het.xml.protocol.coder.utils.StringUtil;

public class Crc16Utils {
    public static int computeChecksum(byte[] data, int length) {
        int j = 0;
        int crc16 = 65535;
        for (int i = 1; i < length; ++i) {
            crc16 ^= data[i] & 0xFF;
            for (j = 0; j < 8; ++j) {
                int flags = crc16 & 1;
                if (flags != 0) {
                    crc16 = crc16 >> 1 ^ 0x8408;
                    continue;
                }
                crc16 >>= 1;
            }
        }
        return ~crc16 & 0xFFFF;
    }

    public static int computeBodyCrc(byte[] data) {
        int j = 0;
        int crc16 = 65535;
        for (int i = 0; i < data.length; ++i) {
            crc16 ^= data[i] & 0xFF;
            for (j = 0; j < 8; ++j) {
                int flags = crc16 & 1;
                if (flags != 0) {
                    crc16 = crc16 >> 1 ^ 0x8408;
                    continue;
                }
                crc16 >>= 1;
            }
        }
        return ~crc16 & 0xFFFF;
    }

    public static void main(String[] args) {
        byte[] bytes = StringUtil.hexStringToByteArray("f241100003accf233ba86a080b00000501007e000017d9f241100003accf233ba86a080b00000501007e0000");
    }
}

