/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.parse;

import android.content.Context;
import android.text.TextUtils;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.BitDefinition;
import com.het.xml.protocol.coder.bean.ByteDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.parse.inter.AnalyzeProtocalXml;
import com.het.xml.protocol.coder.parse.inter.ProtocolXMLFileLoad;
import com.het.xml.protocol.coder.utils.Base64Utils;
import com.het.xml.protocol.coder.utils.StringUtil;
import com.het.xml.protocol.db.DeviceProtocolDao;
import com.het.xml.protocol.db.DeviceProtocolModel;
import com.het.xml.protocol.model.ProtocolBean;
import com.het.xml.protocol.model.ProtocolDataModel;
import com.het.xml.protocol.utils.Logc;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProtocolFileLoadManager
implements ProtocolXMLFileLoad<ProtocolDataModel> {
    private final HashMap<String, ProtocolDefinition> protocolMapper = new HashMap();
    private final HashMap<String, HashMap<String, BaseDefinition>> pro0104Mapper = new HashMap();
    private AnalyzeProtocalXml parser;
    private String filePath;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private DeviceProtocolDao deviceProtocolDao;
    private Context mContext;

    public HashMap<String, ProtocolDefinition> getProtocolMapper() {
        return this.protocolMapper;
    }

    public AnalyzeProtocalXml getParser() {
        return this.parser;
    }

    public void setParser(AnalyzeProtocalXml parser) {
        this.parser = parser;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void loadXMLFiles() {
        this.load(this.filePath);
    }

    public void setContext(Context mContext) {
        this.mContext = mContext.getApplicationContext();
        this.deviceProtocolDao = new DeviceProtocolDao(mContext);
    }

    @Override
    public void load(String filePathRegex) {
        if (filePathRegex == null || "".equals(filePathRegex.trim())) {
            throw new IllegalArgumentException("argument can't be null");
        }
        String[] filePathArr = filePathRegex.split(",");
        String regex = ".*\\.([x|X][m|M][l|L])$";
        File[] files = null;
        Logc.e("start look up matched files...");
        ArrayList<File> fileList = new ArrayList<File>();
        for (String filePath : filePathArr) {
            if ((filePath = filePath.trim()).matches(regex)) {
                int separatorIndex = filePath.lastIndexOf(File.separator);
                String dirPath = filePath.substring(0, separatorIndex);
                String filterRegex = filePath.substring(separatorIndex + 1).toLowerCase().replace(".", "\\.").replace("*", ".*");
                try {
                    files = this.getFiles(dirPath, filterRegex);
                }
                catch (FileNotFoundException e) {
                    Logc.e(e.getMessage());
                }
            } else {
                try {
                    files = this.getFiles(filePath, ".*\\.(xml)$");
                }
                catch (FileNotFoundException e) {
                    Logc.e(e.getMessage());
                }
            }
            if (files == null) continue;
            for (File file : files) {
                String fileName = StringUtil.getFileName(file.getName());
                if (fileName != null) {
                    fileList.add(file);
                    Logc.i("Load from File :" + fileName);
                    continue;
                }
                Logc.i("Load in Sqlite :" + fileName);
            }
        }
        this.loadProtocalDefinition(fileList);
    }

    @Override
    public void loadXmlString(ProtocolDataModel protocolDataModel) {
        if (protocolDataModel == null) {
            return;
        }
        List<ProtocolBean> list = protocolDataModel.getList();
        if (list != null && list.size() > 0) {
            for (ProtocolBean proBean : list) {
                if (proBean == null || TextUtils.isEmpty((CharSequence)proBean.getContent())) continue;
                String xmlString = proBean.getContent();
                if (!TextUtils.isEmpty((CharSequence)proBean.getCommand()) && proBean.getCommand().equalsIgnoreCase("8007")) {
                    proBean.setCommand("4007");
                }
                ProtocolDefinition definition = (ProtocolDefinition)this.parser.paseXML(xmlString);
                StringBuffer sb = new StringBuffer();
                sb.append(proBean.getProductId());
                sb.append("-");
                sb.append(proBean.getCommand());
                definition.setId(sb.toString());
                proBean.setProtocolName(sb.toString());
                this.protocolMapper.put(definition.getId(), definition);
                protocolDataModel.setProductId(proBean.getProductId());
                if (TextUtils.isEmpty((CharSequence)proBean.getCommand()) || !proBean.getCommand().equalsIgnoreCase("0104")) continue;
                this.process0104cmdData(definition);
            }
            DeviceProtocolModel deviceProtocolModel = new DeviceProtocolModel();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
            Date curDate = new Date(System.currentTimeMillis());
            String str = formatter.format(curDate);
            deviceProtocolModel.setUpdateTime(str);
            deviceProtocolModel.setProtocolDate(String.valueOf(protocolDataModel.getProtocolDate()));
            deviceProtocolModel.setProductId(protocolDataModel.getProductId());
            deviceProtocolModel.setBase64data(Base64Utils.getBase64Data(protocolDataModel));
            this.saveXmlStringSqlite(deviceProtocolModel);
        }
    }

    private void process0104cmdData(ProtocolDefinition definition) {
        try {
            List<ByteDefinition> bytelist;
            if (definition != null && (bytelist = definition.getByteDefList()) != null && bytelist.size() > 0) {
                HashMap<String, BaseDefinition> mapper = new HashMap<String, BaseDefinition>();
                int index = 0;
                for (int i = 0; i < bytelist.size(); ++i) {
                    ByteDefinition item = bytelist.get(i);
                    if (item != null) {
                        List<BitDefinition> bList = item.getBitDefList();
                        if (bList != null && bList.size() > 0) {
                            for (int j = 0; j < bList.size(); ++j) {
                                BitDefinition bItem = bList.get(j);
                                if (TextUtils.isEmpty((CharSequence)bItem.getProperty())) continue;
                                bItem.setIndex((index += bItem.getLength().intValue()) - bItem.getLength());
                                mapper.put(bItem.getProperty(), bItem);
                            }
                        } else if (!TextUtils.isEmpty((CharSequence)item.getProperty())) {
                            item.setIndex((index += item.getLength().intValue()) - item.getLength());
                            mapper.put(item.getProperty(), item);
                        }
                    }
                    this.pro0104Mapper.put(definition.getId(), mapper);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProtocalDefinition(List<File> fileList) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            for (File file : fileList) {
                try {
                    ProtocolDefinition definition = (ProtocolDefinition)this.parser.parseXMLFile(file);
                    Logc.i("parse successful file=" + file.getAbsolutePath());
                    String proXmlString = this.parser.toXml(definition);
                    DeviceProtocolModel deviceProtocolModel = new DeviceProtocolModel();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
                    Date curDate = new Date(System.currentTimeMillis());
                    String str = formatter.format(curDate);
                    ProtocolDataModel protocolDataModel = new ProtocolDataModel();
                    protocolDataModel.setProductId(0);
                    protocolDataModel.setProtocolDate(0L);
                    ProtocolBean protocolBean = new ProtocolBean();
                    protocolBean.setContent(proXmlString);
                    protocolBean.setProtocolName(definition.getId());
                    ArrayList<ProtocolBean> list = new ArrayList<ProtocolBean>();
                    protocolDataModel.setList(list);
                    deviceProtocolModel.setUpdateTime(str);
                    deviceProtocolModel.setProtocolDate(String.valueOf(protocolDataModel.getProtocolDate()));
                    deviceProtocolModel.setProductId(protocolDataModel.getProductId());
                    deviceProtocolModel.setBase64data(Base64Utils.getBase64Data(protocolDataModel));
                    this.saveXmlStringSqlite(deviceProtocolModel);
                    this.protocolMapper.put(definition.getId(), definition);
                }
                catch (XStreamException e) {
                    Logc.e("protocol xml file parse error[fileName:{}]-error msg:{} " + file.getAbsolutePath() + e.getMessage());
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private File[] getFiles(String dirPath, final String filterRegex) throws FileNotFoundException {
        Logc.i("\u534f\u8bae\u6587\u4ef6\u5b58\u653e\u5730\u5740\uff1a" + dirPath);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            if (!dir.exists()) {
                throw new FileNotFoundException("can't find the directory[" + dirPath + "]");
            }
            try {
                dirPath = this.getClass().getResource("/").toURI().getPath() + dirPath;
                dir = new File(dirPath);
                if (!dir.exists()) {
                    throw new FileNotFoundException("can't find the directory[" + dirPath + "]");
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = pathname.getName().toLowerCase();
                return path.matches(filterRegex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolDefinition getProtocolDefinition(String id) {
        if (id == null) {
            throw new IllegalArgumentException("paramter can't be null");
        }
        ProtocolDefinition definition = null;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            definition = this.protocolMapper.get(id.toUpperCase());
        }
        finally {
            readLock.unlock();
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, BaseDefinition> get0104Mapper(String id) {
        if (id == null) {
            throw new IllegalArgumentException("paramter can't be null");
        }
        HashMap<String, BaseDefinition> definition = null;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            definition = this.pro0104Mapper.get(id.toUpperCase());
        }
        finally {
            readLock.unlock();
        }
        return definition;
    }

    private void saveXmlStringSqlite(DeviceProtocolModel definition) {
        if (this.deviceProtocolDao != null && definition != null) {
            this.deviceProtocolDao.insert(definition);
        }
    }

    public static void main(String[] at) {
        long cc = System.currentTimeMillis();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
        Date curDate = new Date(cc);
        String str = formatter.format(curDate);
    }

    private void readInSqlteThread(final DeviceProtocolModel productModel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ProtocolDataModel proArr;
                if (ProtocolFileLoadManager.this.deviceProtocolDao != null && productModel != null && (proArr = Base64Utils.getBase64Object(productModel.getBase64data(), ProtocolDataModel.class)) != null && proArr.getList() != null && proArr.getList().size() > 0) {
                    List<ProtocolBean> list = proArr.getList();
                    for (ProtocolBean item : list) {
                        ProtocolDefinition definition = (ProtocolDefinition)ProtocolFileLoadManager.this.parser.paseXML(item.getContent());
                        if (definition == null) continue;
                        StringBuffer sb = new StringBuffer();
                        sb.append(item.getProductVersion());
                        sb.append("-");
                        sb.append(item.getDeviceTypeId());
                        sb.append("-");
                        sb.append(item.getDeviceSubtypeId());
                        sb.append("-");
                        sb.append(item.getCommand());
                        definition.setId(sb.toString());
                        ProtocolFileLoadManager.this.protocolMapper.put(definition.getId(), definition);
                    }
                }
            }
        }).start();
    }

    private void readInSqlte(DeviceProtocolModel productModel) {
        ProtocolDataModel proArr;
        if (this.deviceProtocolDao != null && productModel != null && (proArr = Base64Utils.getBase64Object(productModel.getBase64data(), ProtocolDataModel.class)) != null && proArr.getList() != null && proArr.getList().size() > 0) {
            List<ProtocolBean> list = proArr.getList();
            for (ProtocolBean item : list) {
                ProtocolDefinition definition = (ProtocolDefinition)this.parser.paseXML(item.getContent());
                if (definition == null) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(item.getProductVersion());
                sb.append("-");
                sb.append(item.getDeviceTypeId());
                sb.append("-");
                sb.append(item.getDeviceSubtypeId());
                sb.append("-");
                sb.append(item.getCommand());
                definition.setId(sb.toString());
                this.protocolMapper.put(definition.getId(), definition);
            }
        }
    }

    public String getProtocolDate(int productId) {
        DeviceProtocolModel productModel;
        if (this.deviceProtocolDao != null && (productModel = this.deviceProtocolDao.get(productId)) != null) {
            this.readInSqlte(productModel);
            return productModel.getProtocolDate();
        }
        return "0";
    }

    public ProtocolDataModel getProtocolByProductId(int productId) {
        if (this.deviceProtocolDao == null) {
            return null;
        }
        DeviceProtocolModel deviceProtocolModel = this.deviceProtocolDao.get(productId);
        if (deviceProtocolModel == null) {
            return null;
        }
        ProtocolDataModel proArr = Base64Utils.getBase64Object(deviceProtocolModel.getBase64data(), ProtocolDataModel.class);
        return proArr;
    }

    public void loadAll() {
        if (this.deviceProtocolDao == null) {
            return;
        }
        List<DeviceProtocolModel> deviceProtocolModel = this.deviceProtocolDao.loadAll();
        if (deviceProtocolModel == null) {
            return;
        }
        for (DeviceProtocolModel model : deviceProtocolModel) {
            this.readInSqlte(model);
        }
    }
}

