/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.encode;

import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.encode.AbstractEncoder;
import com.het.xml.protocol.coder.encode.crc.CrcCalculateStrategy;
import com.het.xml.protocol.coder.exception.EncodeException;
import com.het.xml.protocol.coder.parse.ProductorProtocolManager;
import com.het.xml.protocol.utils.Logc;
import java.util.Map;

public class SecondLayerProtocolEncoderExt
extends AbstractEncoder {
    private CrcCalculateStrategy crcCalculate;
    private ProductorProtocolManager protocolManager;

    public void setProtocolManager(ProductorProtocolManager protocolManager) {
        this.protocolManager = protocolManager;
    }

    public void setCrcCalculate(CrcCalculateStrategy crcCalculate) {
        this.crcCalculate = crcCalculate;
    }

    @Override
    public byte[] encode(Object data) throws Exception {
        Map dto = (Map)data;
        String command = dto.get("command").toString();
        Object dataVersion = dto.get("dataVersion");
        Object deviceType = dto.get("deviceType");
        Object deviceSubType = dto.get("deviceSubType");
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(dataVersion).append("-").append(deviceType).append("-").append(deviceSubType).append("-").append(command).append("-").append("E");
        String developerID = dto.get("developerID").toString();
        String protocolID = keyBuilder.toString();
        ProtocolDefinition protocolDefinition = this.protocolManager.get(developerID, protocolID, 1);
        if (protocolDefinition == null) {
            protocolDefinition = this.protocolManager.get(developerID, protocolID, 0);
        }
        if (protocolDefinition == null) {
            Logc.e("[DEVELOPER_ID:{} PROTOCOL_ID:{}]-can't find the protocol configuration" + developerID + protocolID);
            throw new EncodeException("[PROTOCOL_ID:" + protocolID + "]-can't find the protocol configuration");
        }
        byte[] tempData = null;
        try {
            tempData = this.encode(protocolDefinition, data);
        }
        catch (Exception e) {
            Logc.e("[PROTOCOL_ID:" + protocolDefinition.getId() + "]-EXCEPTION" + e);
            throw new EncodeException("[PROTOCOL_ID:" + protocolDefinition.getId() + "]-" + e.getMessage());
        }
        return tempData;
    }
}

