/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.encode;

import android.text.TextUtils;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.encode.AbstractEncoder;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;
import com.het.xml.protocol.utils.Logc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class CalcUpdateFlagEncoder
extends AbstractEncoder {
    @Override
    public byte[] encode(Object data) {
        StringBuilder sb;
        String command = "";
        Object deviceType = null;
        Object deviceSubType = null;
        Object dataVersion = null;
        Object productId = null;
        if (data instanceof TreeMap) {
            TreeMap dto = (TreeMap)data;
            command = StringUtil.byteArrayToHexString(BinaryConvertUtils.longToByteArray(Integer.parseInt(dto.get("command").toString()), 2));
            dataVersion = dto.get("dataVersion");
            deviceType = dto.get("deviceType");
            deviceSubType = dto.get("deviceSubType");
            productId = dto.get("productId");
        }
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append((Object)dataVersion).append("-").append((Object)deviceType).append("-").append((Object)deviceSubType).append("-").append(command);
        String key = keyBuilder.toString();
        ProtocolDefinition protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        if (protocolDefinition == null) {
            key = dataVersion + "";
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            sb = new StringBuilder();
            sb.append("2").append("-").append((Object)deviceType).append("-").append((Object)deviceSubType).append("-").append(command);
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            sb = new StringBuilder();
            sb.append((Object)productId).append("-").append(command);
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            Logc.e("can't find the protocol configuration,protocolId=" + key);
            return null;
        }
        try {
            HashMap<String, BaseDefinition> mapper = this.protocolXmlManager.get0104Mapper(key);
            if (mapper != null) {
                this.processUpdateFlag(data, mapper);
            }
        }
        catch (Exception e) {
            Logc.e("<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
        }
        return null;
    }

    private void processUpdateFlag(Object data, HashMap<String, BaseDefinition> mapper) {
        if (data instanceof TreeMap) {
            TreeMap treeMap = (TreeMap)data;
            if (treeMap != null && treeMap.containsKey("updateFlag")) {
                return;
            }
            TreeMap dto = (TreeMap)data;
            String UPDATEFLAG_KAY = "updateFlag";
            BaseDefinition vv = mapper.get("updateFlag");
            if (vv != null) {
                int updateFlagLength = vv.getLength();
                Iterator keys = dto.keySet().iterator();
                if (keys != null) {
                    ArrayList<BaseDefinition> keyValye = new ArrayList<BaseDefinition>();
                    while (keys.hasNext()) {
                        BaseDefinition tmp;
                        String key = (String)keys.next();
                        if (key == null || key.equalsIgnoreCase("command") || key.equalsIgnoreCase("macAddress") || key.equalsIgnoreCase("deviceType") || key.equalsIgnoreCase("deviceSubType") || key.equalsIgnoreCase("dataVersion") || key.equalsIgnoreCase("updateFlag") || (tmp = mapper.get(key)) == null || tmp.getProperty() == null || !treeMap.containsKey(tmp.getProperty())) continue;
                        keyValye.add(tmp);
                    }
                    String flag = this.calcUpdateFlag(updateFlagLength, keyValye);
                    if (!TextUtils.isEmpty((CharSequence)flag)) {
                        dto.put("updateFlag", flag);
                    }
                }
            }
        }
    }

    private String calcUpdateFlag(int updateFlagLen, List<BaseDefinition> keyValye) {
        if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
            int[][] tempIntHigh = new int[updateFlagLen][8];
            byte[] updateFlag = new byte[updateFlagLen];
            for (int i = 0; i < keyValye.size(); ++i) {
                BaseDefinition bd = keyValye.get(i);
                if (bd == null) continue;
                int index = bd.getIndex();
                int len = bd.getLength();
                for (int k = index; k <= index + len - 1; ++k) {
                    tempIntHigh[k / 8][k % 8] = 1;
                }
            }
            for (int j = 0; j < tempIntHigh.length; ++j) {
                int[] tmpArr = tempIntHigh[j];
                byte des = 0;
                for (int l = tmpArr.length - 1; l >= 0; --l) {
                    if (tmpArr[l] != 1) continue;
                    int tmp = 1;
                    tmp = (byte)(tmp << l);
                    des = (byte)(des | tmp);
                }
                updateFlag[j] = des;
            }
            Logc.e("----------------------bb>" + Arrays.toString(updateFlag));
            String result = StringUtil.byteArrayToHexString(updateFlag);
            System.out.println("----------------------uu>" + result);
            return result;
        }
        return null;
    }
}

