/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol.coder.decode;

import com.het.xml.protocol.coder.DataType;
import com.het.xml.protocol.coder.DataTypeDefinition;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.BitDefinition;
import com.het.xml.protocol.coder.bean.ByteDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.decode.inter.Decoder;
import com.het.xml.protocol.coder.exception.DecodeException;
import com.het.xml.protocol.coder.exception.IllegalAttributeValue;
import com.het.xml.protocol.coder.parse.ProtocolFileLoadManager;
import com.het.xml.protocol.coder.utils.BeanUtils;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;
import com.het.xml.protocol.utils.Logc;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDecoder
implements Decoder {
    private static final Map<String, String> methodNameMap = new HashMap<String, String>();
    protected ProtocolFileLoadManager protocolXmlManager;

    public void setProtocolXmlManager(ProtocolFileLoadManager protocolXmlManager) {
        this.protocolXmlManager = protocolXmlManager;
    }

    @Override
    public abstract <T> T decode(Object var1) throws Exception;

    public <T> T decode(ProtocolDefinition protocolDefinition, byte[] data) throws Exception {
        if (data == null || protocolDefinition == null) {
            throw new IllegalArgumentException("argument can't be null,please check...");
        }
        this.check(protocolDefinition);
        Logc.i("[{}-protocolID:{}]-start decoding data package..." + protocolDefinition.getDescription() + " " + protocolDefinition.getId());
        Class<?> instanceClass = null;
        if (protocolDefinition.getClassName() == null || "".equals(protocolDefinition.getClassName())) {
            instanceClass = Class.forName("java.util.HashMap");
        } else {
            try {
                instanceClass = Class.forName(protocolDefinition.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("[protocolID:" + protocolDefinition.getId() + "]-can't find class\"" + protocolDefinition.getClassName() + "\"");
            }
        }
        T instance = null;
        try {
            instance = (T)instanceClass.newInstance();
        }
        catch (Exception e) {
            throw new DecodeException("[protocolID:" + protocolDefinition.getId() + "]-can't instance\"" + protocolDefinition.getClassName() + "\"");
        }
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(data));
        Object value = null;
        List<ByteDefinition> rule = protocolDefinition.getByteDefList();
        int count = 0;
        for (ByteDefinition element : rule) {
            DataType dataType;
            if (element.getBitDefList() != null) {
                element.setJavaType("BYTE");
                element.setIgnore(true);
            }
            if ((dataType = DataTypeDefinition.getDataType(element.getJavaType())) == null) {
                throw new IllegalAttributeValue("[protocolID:" + protocolDefinition.getId() + " property:" + element.getProperty() + "]-can't support \"" + element.getJavaType() + "\" data type,please check the \"JavaType\" value");
            }
            switch (dataType) {
                case LONG: 
                case INTEGER: {
                    Object tmpValue;
                    Double dValue;
                    try {
                        value = this.readByteByDefinition(element, inputStream, dataType, instance);
                    }
                    catch (Exception e1) {
                        throw new DecodeException("[property:" + element.getProperty() + "]-" + e1.getMessage());
                    }
                    Integer mulriple = element.getMulriple();
                    if (mulriple != null && (dValue = Double.valueOf(Double.parseDouble(value.toString()))) != null) {
                        dValue = dValue / (double)mulriple.intValue();
                        int num = mulriple / 10;
                        String f = String.valueOf(num);
                        int len = f.length();
                        if (num > 0) {
                            value = String.format("%." + len + "f", dValue);
                        }
                    }
                    if ((tmpValue = StringUtil.caclSigned(value, element)) != null) {
                        value = tmpValue;
                    }
                    this.setValue(instance, value, element);
                    break;
                }
                case CHAR: 
                case BYTE: 
                case SHORT: 
                case FLOAT: 
                case DOUBLE: {
                    try {
                        value = this.readByteByDefinition(element, inputStream, dataType, instance);
                    }
                    catch (Exception e1) {
                        throw new DecodeException("[property:" + element.getProperty() + "]-" + e1.getMessage());
                    }
                    Object tmpValue1 = StringUtil.caclSigned(value, element);
                    if (tmpValue1 != null) {
                        value = tmpValue1;
                    }
                    this.setValue(instance, value, element);
                    break;
                }
                case STRING: {
                    try {
                        value = this.readByteByDefinition(element, inputStream, dataType, instance);
                    }
                    catch (Exception e1) {
                        throw new DecodeException("[property:" + element.getProperty() + "]-" + e1.getMessage());
                    }
                    String strValue = new String((byte[])value, "UTF-8");
                    this.setValue(instance, strValue.trim(), element);
                    break;
                }
                case HEX_STRING: {
                    try {
                        value = (byte[])this.readByteByDefinition(element, inputStream, dataType, instance);
                    }
                    catch (Exception e1) {
                        throw new DecodeException("[property:" + element.getProperty() + "]-" + e1.getMessage());
                    }
                    this.setValue(instance, StringUtil.byteArrayToHexString((byte[])value), element);
                    break;
                }
                case BYTE_ARRAY: {
                    try {
                        value = this.readByteByDefinition(element, inputStream, dataType, instance);
                    }
                    catch (Exception e1) {
                        throw new DecodeException("[property:" + element.getProperty() + "]-" + e1.getMessage());
                    }
                    this.setValue(instance, value, element);
                    break;
                }
                default: {
                    Logc.e("[protocolID:" + protocolDefinition.getId() + " property:" + element.getProperty() + "]-does't support the \"JavaType\" {}" + element.getJavaType());
                }
            }
            Object bitVal = null;
            if (element.getBitDefList() != null) {
                for (BitDefinition bitDef : element.getBitDefList()) {
                    try {
                        bitVal = this.readBitByDefiniton(bitDef, (Integer)BinaryConvertUtils.convertNumberToTargetClass((Number)value, Integer.class));
                    }
                    catch (Exception e) {
                        throw new DecodeException("[property:" + bitDef.getProperty() + "]-" + e.getMessage());
                    }
                    this.setValue(instance, bitVal, bitDef);
                }
            }
            ++count;
        }
        return instance;
    }

    private void setValue(Object instance, Object value, BaseDefinition definition) throws IllegalAccessException, InvocationTargetException {
        if (!definition.isIgnore()) {
            if (instance instanceof Map) {
                definition.setValue(value);
                ((Map)instance).put(definition.getProperty(), value);
            } else {
                BeanUtils.setProperty(instance, definition.getProperty(), value);
            }
        }
    }

    private Object readByteByDefinition(ByteDefinition byteDefinition, DataInputStream inputStream, DataType dataType, Object instance) throws Exception {
        Object value = null;
        String methodName = "read";
        if (!StringUtil.isEmpty(byteDefinition.getRefValue())) {
            Integer length = 0;
            if (byteDefinition.getRefValue().matches("^\\w+[+|-]{1}\\d+$")) {
                String[] tempArr;
                if (byteDefinition.getRefValue().contains("+")) {
                    tempArr = byteDefinition.getRefValue().split("\\+");
                    String val = BeanUtils.getProperty(instance, tempArr[0].trim());
                    length = Integer.valueOf(val) + Integer.valueOf(tempArr[1]);
                } else if (byteDefinition.getRefValue().contains("-")) {
                    tempArr = byteDefinition.getRefValue().split("-");
                    String val = BeanUtils.getProperty(instance, tempArr[0].trim());
                    length = Integer.valueOf(val) - Integer.valueOf(tempArr[1]);
                }
            } else if (byteDefinition.getRefValue().matches("^\\d+[+|-]{1}\\w+$")) {
                String[] tempArr;
                if (byteDefinition.getRefValue().contains("+")) {
                    tempArr = byteDefinition.getRefValue().split("\\+");
                    String val = BeanUtils.getProperty(instance, tempArr[1].trim());
                    length = Integer.valueOf(val) + Integer.valueOf(tempArr[0]);
                } else if (byteDefinition.getRefValue().contains("-")) {
                    tempArr = byteDefinition.getRefValue().split("-");
                    String val = BeanUtils.getProperty(instance, tempArr[1].trim());
                    length = Integer.valueOf(val) - Integer.valueOf(tempArr[0]);
                }
            } else {
                short dataLen = (Short)((Map)instance).get(byteDefinition.getRefValue());
                length = dataLen;
            }
            byteDefinition.setLength(length);
        }
        if (StringUtil.isEmpty(byteDefinition.getJavaType())) {
            throw new IllegalAttributeValue("the \"JavaType\" value can't be null");
        }
        if (dataType.getSize() == 0) {
            if (byteDefinition.getLength() == null) {
                throw new IllegalAttributeValue("if the \"javaType\" value is not primitive data type, \"length\" value can't be null or zero");
            }
            byte[] bytes = new byte[byteDefinition.getLength().intValue()];
            DataInputStream.class.getMethod(methodName, byte[].class).invoke((Object)inputStream, new Object[]{bytes});
            value = bytes;
        } else {
            if (byteDefinition.getLength() != null && dataType.getSize() < byteDefinition.getLength()) {
                throw new IllegalAttributeValue("the \"length\" value does't match \"javaType\" value");
            }
            methodName = this.getMethodName(byteDefinition, dataType);
            if ("read".equals(methodName)) {
                int len = byteDefinition.getLength();
                byte[] bytes = new byte[len];
                DataInputStream.class.getMethod(methodName, byte[].class).invoke((Object)inputStream, new Object[]{bytes});
                long lo = BinaryConvertUtils.byteArrayToLong(bytes);
                value = lo;
                if (len % 2 == 0) {
                    if (len == 2) {
                        short sh = (short)lo;
                        value = sh;
                    } else if (len == 4) {
                        int in = (int)lo;
                        value = in;
                    } else {
                        value = lo;
                    }
                }
            } else {
                value = DataInputStream.class.getMethod(methodName, new Class[0]).invoke((Object)inputStream, new Object[0]);
            }
        }
        return value;
    }

    private Object readBitByDefiniton(BitDefinition bitDefinition, int val) throws Exception {
        Integer value = null;
        int[] hexArr = new int[]{1, 3, 7, 15, 31, 63, 127, 255};
        Integer length = bitDefinition.getLength();
        if (length == null || length <= 0) {
            throw new IllegalAttributeValue("label \"bitDef\" does't set \"length\" value");
        }
        if (bitDefinition.getShift() == null) {
            throw new IllegalAttributeValue("label \"bitDef\" does't set \"shift\" value");
        }
        value = val >>> bitDefinition.getShift() & hexArr[length - 1];
        return value;
    }

    private String getMethodName(BaseDefinition definition, DataType dataType) {
        String methodName = null;
        String type = null;
        if (definition.getLength() != null && definition.getLength() > 0) {
            String key = definition.getLength() + "-" + dataType.getCategory();
            if ("number".equals(dataType.getCategory())) {
                if (dataType.getSize() == definition.getLength().intValue()) {
                    type = methodNameMap.get(key);
                }
            } else {
                type = methodNameMap.get(key);
            }
        } else {
            type = dataType.toString();
        }
        methodName = "read" + (type == null ? "" : type);
        return methodName;
    }

    private void check(ProtocolDefinition protocolDefinition) throws DecodeException {
        if (protocolDefinition.getId() == null || "".equals(protocolDefinition.getId())) {
            throw new DecodeException("[protocolID:" + protocolDefinition.getId() + "]-the value of label \"id\" can't be null");
        }
        if (protocolDefinition.getByteDefList() == null || protocolDefinition.getByteDefList().size() == 0) {
            throw new DecodeException("[protocolID:" + protocolDefinition.getId() + "]-the value of label \"definitions\" can't be null");
        }
    }

    static {
        methodNameMap.put("1-char", "Char");
        methodNameMap.put("1-number", "UnsignedByte");
        methodNameMap.put("2-number", "UnsignedShort");
        methodNameMap.put("4-number", "Int");
        methodNameMap.put("4-float", "Float");
        methodNameMap.put("8-number", "Long");
        methodNameMap.put("8-float", "Double");
    }
}

