/*
 * Decompiled with CFR 0.152.
 */
package com.het.xml.protocol;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.het.xml.protocol.coder.decode.SecondLayerProtocolDecoder;
import com.het.xml.protocol.coder.encode.CalcUpdateFlagEncoder;
import com.het.xml.protocol.coder.encode.SecondLayerProtocolEncoder;
import com.het.xml.protocol.coder.parse.AnalyzeProtocalXmlImpl;
import com.het.xml.protocol.coder.parse.ProtocolFileLoadManager;
import com.het.xml.protocol.model.DeviceProBean;
import com.het.xml.protocol.model.PacketDataBean;
import com.het.xml.protocol.model.ProtocolDataModel;
import com.het.xml.protocol.utils.GsonTool;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ProtocolManager {
    private boolean bLoad = false;
    private static volatile ProtocolManager instance = null;
    private ProtocolFileLoadManager protocolFileLoadManager;
    private AnalyzeProtocalXmlImpl analyzeProtocalXml;
    private SecondLayerProtocolDecoder decoder;
    public static ConcurrentHashMap<String, DeviceProBean> deviceList = new ConcurrentHashMap();
    private SecondLayerProtocolEncoder encoder;
    private CalcUpdateFlagEncoder updateFlagEncoder;
    private boolean isAutoCalcUpdateFlag = false;
    private Gson gson;

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

                public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
                    if (src == (double)src.longValue()) {
                        return new JsonPrimitive((Number)src.longValue());
                    }
                    return new JsonPrimitive((Number)src);
                }
            }).create();
        }
        return this.gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProtocolManager getInstance() {
        if (instance != null) return instance;
        Class<ProtocolManager> clazz = ProtocolManager.class;
        synchronized (ProtocolManager.class) {
            if (null != instance) return instance;
            instance = new ProtocolManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isLoad() {
        return this.bLoad;
    }

    public boolean isAutoCalcUpdateFlag() {
        return this.isAutoCalcUpdateFlag;
    }

    public void setAutoCalcUpdateFlag(boolean autoCalcUpdateFlag) {
        this.isAutoCalcUpdateFlag = autoCalcUpdateFlag;
    }

    public void close() {
        this.bLoad = false;
    }

    public static void main(String[] args) {
        ProtocolManager.getInstance().loadProtocolXmlPath("C:\\xml", null);
        ProtocolManager.getInstance().isLoad();
    }

    public String getRunJson(int productId) {
        String json = null;
        try {
            json = ProtocolManager.getInstance().getJsonFormat(productId, (short)261);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (TextUtils.isEmpty((CharSequence)json)) {
                json = ProtocolManager.getInstance().getJsonFormat(productId, (short)5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public String getConfigJson(int productId) {
        String json = null;
        try {
            json = ProtocolManager.getInstance().getJsonFormat(productId, (short)260);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (TextUtils.isEmpty((CharSequence)json)) {
                json = ProtocolManager.getInstance().getJsonFormat(productId, (short)16391);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public String getDeviceJson(int productId, short cmd) {
        String json = null;
        try {
            json = ProtocolManager.getInstance().getJsonFormat(productId, cmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public String getJsonFormat(int productId, short cmd) throws Exception {
        if (this.decoder == null) {
            this.decoder = new SecondLayerProtocolDecoder();
        }
        this.decoder = new SecondLayerProtocolDecoder();
        this.decoder.setProtocolXmlManager(this.protocolFileLoadManager);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("command", Short.valueOf(cmd));
        map.put("productId", Integer.valueOf(productId));
        map.put("empty", Boolean.valueOf(true));
        HashMap config = (HashMap)this.decoder.decode(map);
        if (this.gson == null) {
            this.gson = this.getGson();
        }
        return this.gson.toJson((Object)config);
    }

    public String decode(PacketDataBean packet) throws Exception {
        if (this.protocolFileLoadManager == null) {
            return null;
        }
        if (packet == null) {
            throw new IllegalArgumentException("Packet is null...");
        }
        if (packet.getBody() == null) {
            throw new IllegalArgumentException("body data is null...");
        }
        if (this.decoder == null) {
            this.decoder = new SecondLayerProtocolDecoder();
        }
        this.decoder = new SecondLayerProtocolDecoder();
        this.decoder.setProtocolXmlManager(this.protocolFileLoadManager);
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("deviceType", packet.getDeviceType() + "");
        map.put("deviceSubType", packet.getDeviceSubType() + "");
        map.put("command", packet.getCommand());
        map.put("data", packet.getBody());
        map.put("dataVersion", packet.getDataVersion() == null ? 1 : packet.getDataVersion());
        this.addParamToMap(map, packet.getDeviceMac());
        HashMap config = (HashMap)this.decoder.decode(map);
        if (this.gson == null) {
            this.gson = this.getGson();
        }
        return this.gson.toJson((Object)config);
    }

    public String decode1(PacketDataBean packet) throws Exception {
        if (this.protocolFileLoadManager == null) {
            return null;
        }
        if (packet == null) {
            throw new IllegalArgumentException("Packet is null...");
        }
        if (packet.getBody() == null) {
            throw new IllegalArgumentException("body data is null...");
        }
        if (this.decoder == null) {
            this.decoder = new SecondLayerProtocolDecoder();
        }
        this.decoder = new SecondLayerProtocolDecoder();
        this.decoder.setProtocolXmlManager(this.protocolFileLoadManager);
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("deviceType", packet.getDeviceType() + "");
        map.put("deviceSubType", packet.getDeviceSubType() + "");
        map.put("command", packet.getCommand());
        map.put("data", packet.getBody());
        map.put("dataVersion", packet.getDataVersion() == null ? 1 : packet.getDataVersion());
        this.addParamToMap(map, packet.getDeviceMac());
        HashMap config = (HashMap)this.decoder.decode(map);
        this.decoder.updataFlagFilter(config);
        if (this.gson == null) {
            this.gson = this.getGson();
        }
        return this.gson.toJson((Object)config);
    }

    public byte[] encode(PacketDataBean packet) throws Exception {
        if (packet == null) {
            throw new IllegalArgumentException("Packet is null...");
        }
        if (this.protocolFileLoadManager == null) {
            return null;
        }
        if (packet.getJson() == null) {
            throw new IllegalArgumentException("json data is null...");
        }
        if (this.protocolFileLoadManager == null) {
            throw new IllegalArgumentException("xml is not load...");
        }
        if (this.encoder == null) {
            this.encoder = new SecondLayerProtocolEncoder();
        }
        if (this.gson == null) {
            this.gson = this.getGson();
        }
        this.encoder.setProtocolXmlManager(this.protocolFileLoadManager);
        Type type = new TypeToken<TreeMap<String, Object>>(){}.getType();
        TreeMap map = (TreeMap)this.gson.fromJson(packet.getJson(), type);
        map.put("command", packet.getCommand());
        map.put("macAddress", packet.getDeviceMac());
        map.put("deviceType", packet.getDeviceType());
        map.put("deviceSubType", packet.getDeviceSubType());
        map.put("dataVersion", packet.getDataVersion() == null ? 1 : packet.getDataVersion());
        this.addParamToMap(map, packet.getDeviceMac());
        byte[] data = this.encoder.encode(map);
        return data;
    }

    public String calcUpdateFlag(PacketDataBean packet) {
        if (packet == null) {
            throw new IllegalArgumentException("Packet is null...");
        }
        if (this.protocolFileLoadManager == null) {
            return packet.getJson();
        }
        if (this.updateFlagEncoder == null) {
            this.updateFlagEncoder = new CalcUpdateFlagEncoder();
        }
        if (this.gson == null) {
            this.gson = this.getGson();
        }
        this.updateFlagEncoder.setProtocolXmlManager(this.protocolFileLoadManager);
        Type type = new TypeToken<TreeMap<String, Object>>(){}.getType();
        TreeMap map = (TreeMap)this.gson.fromJson(packet.getJson(), type);
        map.put("command", packet.getCommand() == 0 ? (short)260 : (short)packet.getCommand());
        map.put("macAddress", packet.getDeviceMac());
        map.put("deviceType", packet.getDeviceType());
        map.put("deviceSubType", packet.getDeviceSubType());
        map.put("dataVersion", packet.getDataVersion() == null ? 1 : packet.getDataVersion());
        this.addParamToMap(map, packet.getDeviceMac());
        this.updateFlagEncoder.encode(map);
        map.remove("command");
        map.remove("macAddress");
        map.remove("deviceType");
        map.remove("deviceSubType");
        map.remove("dataVersion");
        map.remove("productId");
        if (this.gson == null) {
            this.gson = this.getGson();
        }
        return this.gson.toJson((Object)map);
    }

    private void addParamToMap(Map<String, Object> map, String mac) {
        if (map == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)mac)) {
            return;
        }
        DeviceProBean device = deviceList.get(mac.toUpperCase());
        if (device == null) {
            return;
        }
        map.put("productId", device.getProductId());
    }

    public void loadProtocolXmlPath(String path, Context context) {
        if (this.protocolFileLoadManager == null) {
            this.protocolFileLoadManager = new ProtocolFileLoadManager();
        }
        if (this.analyzeProtocalXml == null) {
            this.analyzeProtocalXml = new AnalyzeProtocalXmlImpl();
        }
        this.protocolFileLoadManager.setContext(context);
        this.protocolFileLoadManager.setParser(this.analyzeProtocalXml);
        this.protocolFileLoadManager.load(path);
        this.bLoad = true;
    }

    public ProtocolDataModel loadFromJson(Context content, String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject == null) {
                return null;
            }
            if (this.gson == null) {
                this.gson = this.getGson();
            }
            String data = json;
            if (jsonObject.has("data")) {
                data = jsonObject.getString("data");
            }
            if (!TextUtils.isEmpty((CharSequence)data)) {
                Type type = new TypeToken<ProtocolDataModel>(){}.getType();
                ProtocolDataModel proArr = (ProtocolDataModel)this.gson.fromJson(data, type);
                if (proArr == null) {
                    return null;
                }
                this.loadFromBean(content, proArr);
                return proArr;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.bLoad = true;
        return null;
    }

    public void loadFromBean(Context content, ProtocolDataModel proArr) {
        if (this.protocolFileLoadManager == null) {
            this.protocolFileLoadManager = new ProtocolFileLoadManager();
        }
        if (this.analyzeProtocalXml == null) {
            this.analyzeProtocalXml = new AnalyzeProtocalXmlImpl();
        }
        this.protocolFileLoadManager.setContext(content);
        this.protocolFileLoadManager.setParser(this.analyzeProtocalXml);
        this.protocolFileLoadManager.loadXmlString(proArr);
        this.bLoad = true;
    }

    public ProtocolDataModel getProtocolByProductId(Context context, int productId) {
        if (this.protocolFileLoadManager == null) {
            this.protocolFileLoadManager = new ProtocolFileLoadManager();
        }
        if (this.analyzeProtocalXml == null) {
            this.analyzeProtocalXml = new AnalyzeProtocalXmlImpl();
        }
        this.protocolFileLoadManager.setContext(context);
        this.protocolFileLoadManager.setParser(this.analyzeProtocalXml);
        this.bLoad = true;
        return this.protocolFileLoadManager.getProtocolByProductId(productId);
    }

    public void load(Context context) {
        if (this.protocolFileLoadManager == null) {
            this.protocolFileLoadManager = new ProtocolFileLoadManager();
        }
        if (this.analyzeProtocalXml == null) {
            this.analyzeProtocalXml = new AnalyzeProtocalXmlImpl();
        }
        this.protocolFileLoadManager.setContext(context);
        this.protocolFileLoadManager.setParser(this.analyzeProtocalXml);
        this.protocolFileLoadManager.loadAll();
        this.bLoad = true;
    }

    public String getProtocolDate(Context context, int productId) {
        if (this.protocolFileLoadManager == null) {
            this.protocolFileLoadManager = new ProtocolFileLoadManager();
        }
        if (this.analyzeProtocalXml == null) {
            this.analyzeProtocalXml = new AnalyzeProtocalXmlImpl();
        }
        this.protocolFileLoadManager.setContext(context);
        this.protocolFileLoadManager.setParser(this.analyzeProtocalXml);
        this.bLoad = true;
        return this.protocolFileLoadManager.getProtocolDate(productId);
    }

    public String getProtocolDate(Context context, Object obj) {
        if (obj == null) {
            return null;
        }
        String deviceJson = GsonTool.getInstance().toJson(obj);
        if (TextUtils.isEmpty((CharSequence)deviceJson)) {
            return null;
        }
        DeviceProBean deviceProBean = GsonTool.getInstance().toObject(deviceJson, DeviceProBean.class);
        if (deviceProBean == null) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)deviceProBean.getMacAddress())) {
            deviceList.put(deviceProBean.getMacAddress().toUpperCase(), deviceProBean);
        }
        return "0";
    }

    public void addDevice(DeviceProBean bean) {
        if (bean == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)bean.getMacAddress())) {
            deviceList.put(bean.getMacAddress().toUpperCase(), bean);
        }
    }
}

