package com.het.xml.protocol.coder.encode;


import android.text.TextUtils;

import com.het.xml.protocol.utils.Logc;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.exception.EncodeException;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SecondLayerProtocolEncoder extends AbstractEncoder {

    @Override
    public byte[] encode(Object data) throws Exception {
        String command = "";
        //第二层协议版本号
        //第一层协议版本号
        Object deviceType = null;
        Object deviceSubType = null;
        Object dataVersion = null;
        Object productId = null;
        if (data instanceof Map) {
            Map dto = (Map) data;
            //获取命令码
            command = StringUtil.byteArrayToHexString(BinaryConvertUtils.longToByteArray(Integer.parseInt(dto.get("command").toString()), 2));
            dataVersion = dto.get("dataVersion");
            deviceType = dto.get("deviceType");
            deviceSubType = dto.get("deviceSubType");
            productId = dto.get("productId");
        } else {
//            BaseDto dto = (BaseDto) data;
//            //获取命令码
//            command = StringUtil.byteArrayToHexString(BinaryConvertUtils.longToByteArray(dto.getCommand(), 2));
//            dataVersion = dto.getVersion();
//            deviceType = dto.getDeviceType();
//            deviceSubType = dto.getDeviceSubType();
        }

        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(dataVersion).append("-")
                .append(deviceType).append("-")
                .append(deviceSubType).append("-")
                .append(command);//.append("-").append("E");
        //获取包开头标识码
        String key = keyBuilder.toString();
        ProtocolDefinition protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        if (protocolDefinition == null) {
            key = dataVersion + "";// + "-" + command + "-E";
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("2").append("-")
                    .append(deviceType).append("-")
                    .append(deviceSubType).append("-")
                    .append(command);//.append("-").append("E");
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }

        if (protocolDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(productId);
            sb.append("-");
            sb.append(command);
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            Logc.e( "can't find the protocol configuration,protocolId=" + key);
            throw new EncodeException("<PROTOCOL_ID:" + key + "> can't find the protocol configuration");
        }
        byte tempData[] = null;
//        if (ProtocolManager.getInstance().isAutoCalcUpdateFlag()) {
        try {
            HashMap<String, BaseDefinition> mapper = this.protocolXmlManager.get0104Mapper(key);
            if (mapper != null) {
                processUpdateFlag(data, mapper);
            }
        } catch (Exception e) {
            Logc.e("<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
        }
//        }
        try {
            tempData = this.encode(protocolDefinition, data);
        } catch (Exception e) {
            Logc.e( "<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
            throw new EncodeException("PROTOCOL_ID=" + protocolDefinition.getId() + " exception=" + e.getMessage());
        }
        return tempData;
    }


    private void processUpdateFlag(Object data, HashMap<String, BaseDefinition> mapper) {
        if (data instanceof TreeMap) {
            TreeMap treeMap = (TreeMap) data;
            //1.首先，控制数据(json)不包含updateFlag 才计算updateFlag
            if (treeMap != null && treeMap.containsKey("updateFlag"))
                return;
            TreeMap<String, Object> dto = (TreeMap<String, Object>) data;
            final String UPDATEFLAG_KAY = "updateFlag";
            BaseDefinition vv = mapper.get(UPDATEFLAG_KAY);
            //2.其次，设备xml协议里面包含updateFlag
            if (vv != null) {
                int updateFlagLength = vv.getLength();
                Iterator<String> keys = dto.keySet().iterator();
                if (keys != null) {
                    List<BaseDefinition> keyValye = new ArrayList<BaseDefinition>();
                    //////////////////取出设备字段 start
                    while (keys.hasNext()) {
                        String key = keys.next();
                        if (key == null)
                            continue;
                        if (key.equalsIgnoreCase("command") ||
                                key.equalsIgnoreCase("macAddress") ||
                                key.equalsIgnoreCase("deviceType") ||
                                key.equalsIgnoreCase("deviceSubType") ||
                                key.equalsIgnoreCase("dataVersion") ||
                                key.equalsIgnoreCase(UPDATEFLAG_KAY))
                            continue;
                        //处理事务 updateFlag
                        BaseDefinition tmp = mapper.get(key);
                        if (tmp != null && tmp.getProperty() != null && treeMap.containsKey(tmp.getProperty())) {
                            keyValye.add(tmp);
                        }
                    }
                    /////////////////////取出设备字段 end
                    String flag = calcUpdateFlag(updateFlagLength, keyValye);
                    if (!TextUtils.isEmpty(flag)) {
                        dto.put(UPDATEFLAG_KAY, flag);
                    }
                }
            }
        }
    }

    public static void main(String[] ars){
        //CFFFFF0F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
        //FFFFFF0F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
        //FF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
        //3F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
        //FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF03
        String hex = "FFFFFFFFFFFFFFFFFF3F0000000000000000000000000000000000000000000000000";
        int len = hex.length()/2;
        int[][] tmpInt = new int[len][8];
        for (int i = 0;i<len;i++){
//            tmpInt[i][]
        }

        String str = "000AB";
        Integer in = Integer.valueOf(str,16);
        String st = Integer.toHexString(in).toUpperCase();
        st = String.format("%5s",st);
        st= st.replaceAll(" ","0");
        System.out.println(st);
    }

    private String calcUpdateFlag(int updateFlagLen, List<BaseDefinition> keyValye) {
        //keyValye里面存储的设备全部字段
        if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
            int[][] tempIntHigh = new int[updateFlagLen][8];//表示一个字节，8个bit位
            byte[] updateFlag = new byte[updateFlagLen];//updataFlag的字节长度
            for (int i = 0; i < keyValye.size(); i++) {
                BaseDefinition bd = keyValye.get(i);
                if (bd != null) {
                    int index = bd.getIndex();//获取该字段的字节序
                    int len = bd.getLength();//获取该字段的字节长度
                    //从该字段字节索引起始，字节长度结束
                    for (int k = index; k <= (index + len - 1); k++) {
                        tempIntHigh[k / 8][k % 8] = 1;
                    }
                }
            }
            for (int j = 0; j < tempIntHigh.length; j++) {
                int[] tmpArr = tempIntHigh[j];
                byte des = 0;
                byte tmp;
                for (int l = tmpArr.length - 1; l >= 0; l--) {
                    if (tmpArr[l] == 1) {
                        tmp = 1;
                        tmp <<= l;
                        des |= tmp;
                    }
                }
                updateFlag[j] = des;
            }
            Logc.e("----------------------udpbb>" + Arrays.toString(updateFlag));
            String result = StringUtil.byteArrayToHexString(updateFlag);
            //System.out.println("----------------------uu>" + result);
            return result;
        }
        return null;
    }

    private String calcUpdateFlag1(int updateFlagLen, List<BaseDefinition> keyValye) {
        if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
            boolean[] flag = new boolean[updateFlagLen * 8];
            byte[] updateFlag = new byte[updateFlagLen];
            for (int i = 0; i < keyValye.size(); i++) {
                BaseDefinition bd = keyValye.get(i);
                if (bd != null) {
                    int po = calcIndex(updateFlagLen, bd.getIndex());
                    int len = bd.getLength();
                    for (int j = 0; j < len; j++) {
                        flag[po - j] = true;//po=3 j=4
                    }
                }
            }
            for (int k = 0; k < updateFlagLen; k++) {
                byte des = 0;
                byte tmp = 1;
                for (int m = 0; m < 8; m++) {
                    if (flag[8 * (updateFlagLen - k - 1) + m]) {
                        tmp = 1;
                        tmp <<= m;
                        des |= tmp;
                    }
                }
                updateFlag[k] = des;
            }
            Logc.e("----------------------bb>" + Arrays.toString(flag));
            String result = StringUtil.byteArrayToHexString(updateFlag);
            System.out.println("----------------------uu>" + result);
            return result;
        }
        return null;
    }

    private int calcIndex(int updateFlagLen, int index) {
        int value = index / 8;
        int remain = index % 8;
        int xx = value + (remain == 0 ? 0 : 1);
        int po = 8 * (updateFlagLen - xx) + (remain == 0 ? 8 : remain);
        if (po <= (updateFlagLen * 8)) {
            return po - 1;
        }
        return -1;
    }

}

/**
 * 一、后台支持按高位或者低位计算updateFlag:（以8个比特为一组）
 *
 * 如修改第一个协议字段：
 *
 * 0000 0001 | 0000 0000  高位
 *
 * 0000 0000 | 0000 0001  低位
 *
 *
 * 1、获取产品的协议，初始化updateFlag数组：
 *
 * 	//计算updateFlag的值(高位)
 * 	int[][] tempInt = new int[updateFlagLen][8];
 * 	//计算updateFlag的值(低位)
 * 	int[] tempIntLow = new int[updateFlagLen*8];
 *
 * 2、计算非updateFlag的协议字段长度以及它们的和
 *
 * 3、对updateFlag数组的相应的位置1：
 *
 *
 * 	for(int i = preLen[s]; i <= (preLen[s]+keyLen[s]-1);i++){
 * 		tempInt[i/8][i % 8] = 1;
 *        }
 * 	for(int i = preLen[s]; i <= (preLen[s]+keyLen[s]-1);i++){
 * 		tempIntLow[i] = 1;
 *    }
 *
 *
 * 	如修改第一个协议字段，长度为1：
 *
 * 	0000 0001 | 0000 0000  高位
 *
 * 	0000 0000 | 0000 0001  低位
 *
 * 	如修改第一个协议字段，长度为3：
 *
 * 	0000 0111 | 0000 0000  高位
 *
 * 	0000 0000 | 0000 0111  低位
 *
 * 4、把数组转化成十六进制的字符串
 *
 * 5、根据后台的配置，选择下发高位还是低位updateFlag
 */
