package com.het.xml.protocol.coder.encode;

import android.text.TextUtils;

import com.het.xml.protocol.utils.Logc;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.exception.EncodeException;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CalcUpdateFlagEncoder extends AbstractEncoder {

    @Override
    public byte[] encode(Object data)  {
        String command = "";
        //第二层协议版本号
        //第一层协议版本号
        Object deviceType = null;
        Object deviceSubType = null;
        Object dataVersion = null;
        Object productId = null;
        if (data instanceof TreeMap) {
            TreeMap dto = (TreeMap) data;
            //获取命令码
            command = StringUtil.byteArrayToHexString(BinaryConvertUtils.longToByteArray(Integer.parseInt(dto.get("command").toString()), 2));
            dataVersion = dto.get("dataVersion");
            deviceType = dto.get("deviceType");
            deviceSubType = dto.get("deviceSubType");
            productId = dto.get("productId");
        } else {
        }

        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(dataVersion).append("-")
                .append(deviceType).append("-")
                .append(deviceSubType).append("-")
                .append(command);//.append("-").append("E");
        //获取包开头标识码
        String key = keyBuilder.toString();
        ProtocolDefinition protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        if (protocolDefinition == null) {
            key = dataVersion + "";// + "-" + command + "-E";
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("2").append("-")
                    .append(deviceType).append("-")
                    .append(deviceSubType).append("-")
                    .append(command);//.append("-").append("E");
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }

        if (protocolDefinition == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(productId).append("-")
                    .append(command);
            key = sb.toString();
            protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
        }
        if (protocolDefinition == null) {
            Logc.e( "can't find the protocol configuration,protocolId=" + key);
            //throw new EncodeException("<PROTOCOL_ID:" + key + "> can't find the protocol configuration");
            return null;
        }
        try {
            HashMap<String, BaseDefinition> mapper = this.protocolXmlManager.get0104Mapper(key);
            if (mapper != null) {
                processUpdateFlag(data, mapper);
            }
        } catch (Exception e) {
            Logc.e( "<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
        }
        return null;
    }


    private void processUpdateFlag(Object data, HashMap<String, BaseDefinition> mapper) {
        if (data instanceof TreeMap) {
            TreeMap treeMap = (TreeMap) data;
            //1.首先，控制数据(json)不包含updateFlag 才计算updateFlag
            if (treeMap != null && treeMap.containsKey("updateFlag"))
                return;
            TreeMap<String, Object> dto = (TreeMap<String, Object>) data;
            final String UPDATEFLAG_KAY = "updateFlag";
            BaseDefinition vv = mapper.get(UPDATEFLAG_KAY);
            //2.其次，设备xml协议里面包含updateFlag
            if (vv != null) {
                int updateFlagLength = vv.getLength();
                Iterator<String> keys = dto.keySet().iterator();
                if (keys != null) {
                    List<BaseDefinition> keyValye = new ArrayList<BaseDefinition>();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        if (key == null)
                            continue;
                        if (key.equalsIgnoreCase("command") ||
                                key.equalsIgnoreCase("macAddress") ||
                                key.equalsIgnoreCase("deviceType") ||
                                key.equalsIgnoreCase("deviceSubType") ||
                                key.equalsIgnoreCase("dataVersion") ||
                                key.equalsIgnoreCase(UPDATEFLAG_KAY))
                            continue;
                        //处理事务 updateFlag
                        BaseDefinition tmp = mapper.get(key);
                        if (tmp != null && tmp.getProperty() != null && treeMap.containsKey(tmp.getProperty())) {
                            keyValye.add(tmp);
                        }
                    }
                    String flag = calcUpdateFlag(updateFlagLength, keyValye);
                    if (!TextUtils.isEmpty(flag)) {
                        dto.put(UPDATEFLAG_KAY, flag);
                    }
                }
            }
        }
    }

    private String calcUpdateFlag(int updateFlagLen, List<BaseDefinition> keyValye) {
        if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
            int[][] tempIntHigh = new int[updateFlagLen][8];
            byte[] updateFlag = new byte[updateFlagLen];
            for (int i = 0; i < keyValye.size(); i++) {
                BaseDefinition bd = keyValye.get(i);
                if (bd != null) {
                    int index = bd.getIndex();
                    int len = bd.getLength();
                    for (int k = index; k <= (index + len - 1); k++) {
                        tempIntHigh[k / 8][k % 8] = 1;
                    }
                }
            }
            for (int j = 0; j < tempIntHigh.length; j++) {
                int[] tmpArr = tempIntHigh[j];
                byte des = 0;
                byte tmp;
                for (int l = tmpArr.length - 1; l >= 0; l--) {
                    if (tmpArr[l] == 1) {
                        tmp = 1;
                        tmp <<= l;
                        des |= tmp;
                    }
                }
                updateFlag[j] = des;
            }
            Logc.e("----------------------bb>" + Arrays.toString(updateFlag));
            String result = StringUtil.byteArrayToHexString(updateFlag);
            System.out.println("----------------------uu>" + result);
            return result;
        }
        return null;
    }
}