package com.het.xml.protocol.coder.decode;


import android.text.TextUtils;

import com.het.xml.protocol.utils.Logc;
import com.het.xml.protocol.coder.bean.BaseDefinition;
import com.het.xml.protocol.coder.bean.ByteDefinition;
import com.het.xml.protocol.coder.bean.ProtocolDefinition;
import com.het.xml.protocol.coder.exception.DecodeException;
import com.het.xml.protocol.coder.utils.BinaryConvertUtils;
import com.het.xml.protocol.coder.utils.StringUtil;
import com.het.xml.protocol.utils.StrUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * 功能：用于设备数据的解析 第二层协议解码器
 *
 * @Original jake  @improver uuxia
 */
public class SecondLayerProtocolDecoder extends AbstractDecoder {
    private HashMap<String, BaseDefinition> mapper = null;

    @Override
    public <T> T decode(Object data) throws Exception {
        Object result = null;
        if (data instanceof Map) {
            Map map = (Map) data;
            Object dataVersion = map.get("dataVersion");
            Object deviceType = map.get("deviceType");
            Object deviceSubType = map.get("deviceSubType");
            short cmd = (Short) map.get("command");
            Object productId = map.get("productId");
            String command = StringUtil.byteArrayToHexString(BinaryConvertUtils
                    .longToByteArray(cmd, 2));
            StringBuilder keyBuilder = new StringBuilder();
            //协议ID：
            keyBuilder.append(dataVersion).append("-")
                    .append(deviceType).append("-")
                    .append(deviceSubType).append("-")
                    .append(command);//.append("-").append("D");
            String key = keyBuilder.toString();
            byte[] deviceData = (byte[]) map.get("data");
            boolean empty = map.get("empty") == null ? false : (Boolean) map.get("empty");

            ProtocolDefinition protocolDefinition = this.protocolXmlManager
                    .getProtocolDefinition(key);

            if (protocolDefinition == null) {
                key = dataVersion + "-" + command;// + "-D";
                protocolDefinition = this.protocolXmlManager.getProtocolDefinition(key);
            }
            if (protocolDefinition == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("2").append("-")
                        .append(deviceType).append("-")
                        .append(deviceSubType).append("-")
                        .append(command);
                key = sb.toString();
                protocolDefinition = this.protocolXmlManager.getProtocolDefinition(sb.toString());
            }

            if (protocolDefinition == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(productId).append("-")
                        .append(command);
                key = sb.toString();
                protocolDefinition = this.protocolXmlManager.getProtocolDefinition(sb.toString());
            }

            if (protocolDefinition == null) {
                Logc.e(
                        "<PROTOCOL_ID:{}>can't find the protocol configuration" + key);
                throw new DecodeException(
                        "<PROTOCOL_ID:" + key + ">can't find the protocol configuration");
            }

            int bodyLen = calcBodyLength(protocolDefinition);
            if (empty/*&&deviceData==null*/) {
                deviceData = new byte[bodyLen];
            }
            if (deviceData == null) {
                Logc.e( "deviceData is null. PROTOCOL_ID:" + key);
                throw new DecodeException("deviceData is null. PROTOCOL_ID:" + key);
            }
            try {
                mapper = this.protocolXmlManager.get0104Mapper(key);
            } catch (Exception e) {
                Logc.e( "<PROTOCOL_ID=" + key + ">EXCEPTION=" + e);
            }

            try {
                result = this.decode(protocolDefinition, deviceData);
            } catch (Exception e) {
                Logc.e( "<PROTOCOL_ID:" + key + ">EXCEPTION" + e);
                throw new DecodeException("<PROTOCOL_ID:" + protocolDefinition.getId() + ">" + e.getMessage());
            }
        }
        return (T) result;
    }

    private int calcBodyLength(ProtocolDefinition protocolDefinition) {
        List<ByteDefinition> byteList = protocolDefinition.getByteDefList();
        int len = 0;
        for (ByteDefinition item : byteList) {
            len += item.getLength() == null ? 1 : item.getLength();
        }
        Logc.i( "bodyLen = " + len);
        return len;
    }


    public void updataFlagFilter(HashMap dto) {
        if (mapper != null) {
            final String UPDATEFLAG_KAY = "updateFlag";
            //1.首先，控制数据(json)不包含updateFlag 才计算updateFlag
            if (dto == null || !dto.containsKey(UPDATEFLAG_KAY))
                return;
            String updataFlag = (String) dto.get(UPDATEFLAG_KAY);
            if (TextUtils.isEmpty(updataFlag))
                return;
            List<String> list = StrUtil.getStrList(updataFlag,2);
            BaseDefinition vv = mapper.get(UPDATEFLAG_KAY);
            //2.其次，设备xml协议里面包含updateFlag
            if (vv != null) {
                int updateFlagLen = vv.getLength();
                List<BaseDefinition> keyValye = new ArrayList<BaseDefinition>(mapper.values());
                if (updateFlagLen > 0 && keyValye != null && keyValye.size() > 0) {
                    for (int i = 0; i < keyValye.size(); i++) {
                        BaseDefinition bd = keyValye.get(i);
                        String key = bd.getProperty();
                        if (bd != null) {
                            int index = bd.getIndex();//获取该字段的字节序
                            int pos1 = index / 8;//表示第几个字节
                            int pos2 = index % 8;//表示字节里的第几个bit位
                            int value = 1 << pos2;
                            String destStr = list.get(pos1);
                            Integer destInt = Integer.valueOf(destStr,16);
                            int destValue = destInt.intValue();
                            if ((destValue & value) == value){
                            }else{
                                dto.remove(key);
                            }

                        }
                    }
                }
            }
        }
    }

}
