/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.logger;

import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.logger.PerfLoggerRemoting;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;

class PerfLoggerServerThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(PerfLoggerServerThread.class);
    ServerSocket serverSocket;
    boolean done;

    static PerfLoggerServerThread spawn(final int serverPort) {
        return AccessController.doPrivileged(new PrivilegedAction<PerfLoggerServerThread>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PerfLoggerServerThread run() {
                ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(null);
                    PerfLoggerServerThread thread = new PerfLoggerServerThread(serverPort);
                    thread.start();
                    PerfLoggerServerThread perfLoggerServerThread = thread;
                    return perfLoggerServerThread;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(savedClassLoader);
                }
            }
        });
    }

    private PerfLoggerServerThread(int serverPort) {
        this.setDaemon(true);
        this.setName("PerfLoggerServer acceptor port " + serverPort);
        try {
            this.serverSocket = new ServerSocket(serverPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.done) {
                try {
                    Socket socket = this.serverSocket.accept();
                    LOGGER.debug("Got client connection from " + socket);
                    PerfLoggerRemoting.LogSender sender = new PerfLoggerRemoting.LogSender(socket);
                    Thread logSenderThread = new Thread((Runnable)sender, "PerfLoggerServer " + socket.getInetAddress() + ":" + socket.getPort());
                    logSenderThread.setDaemon(true);
                    logSenderThread.start();
                    PerfLoggerRemoting.senders.add(sender);
                }
                catch (IOException e) {
                    LOGGER.error("error while accepting socket", e);
                }
            }
        }
        finally {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOGGER.error("error while closing socket", e);
            }
        }
    }
}

