/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.logger;

import ch.sla.jdbcperflogger.DriverConfig;
import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.driver.LoggingConnectionInvocationHandler;
import ch.sla.jdbcperflogger.logger.PerfLoggerClientThread;
import ch.sla.jdbcperflogger.logger.PerfLoggerServerThread;
import ch.sla.jdbcperflogger.model.BufferFullLogMessage;
import ch.sla.jdbcperflogger.model.ConnectionInfo;
import ch.sla.jdbcperflogger.model.LogMessage;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class PerfLoggerRemoting {
    static final Set<LogSender> senders = new CopyOnWriteArraySet<LogSender>();
    static final Map<LoggingConnectionInvocationHandler, ConnectionInfo> connectionToInfo = new WeakHashMap<LoggingConnectionInvocationHandler, ConnectionInfo>();

    private PerfLoggerRemoting() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connectionCreated(LoggingConnectionInvocationHandler connectionHandler, long connectionCreationDuration) {
        ConnectionInfo info = new ConnectionInfo(connectionHandler.getConnectionUuid(), connectionHandler.getConnectionId(), connectionHandler.getUrl(), new Date(), connectionCreationDuration, connectionHandler.getConnectionProperties());
        Map<LoggingConnectionInvocationHandler, ConnectionInfo> map = connectionToInfo;
        synchronized (map) {
            connectionToInfo.put(connectionHandler, info);
            PerfLoggerRemoting.postLog(info);
        }
    }

    static void postLog(LogMessage log) {
        for (LogSender sender : senders) {
            sender.postLog(log);
        }
    }

    static {
        Integer serverPort = DriverConfig.INSTANCE.getServerPort();
        if (serverPort != null) {
            PerfLoggerServerThread.spawn(serverPort);
        }
        for (InetSocketAddress clientAddress : DriverConfig.INSTANCE.getClientAddresses()) {
            PerfLoggerClientThread.spawn(clientAddress);
        }
    }

    public static class LogSender
    implements Runnable {
        private static final Logger LOGGER2 = Logger.getLogger(LogSender.class);
        private final BlockingQueue<LogMessage> logsToSend = new LinkedBlockingQueue<LogMessage>(10000);
        private final Socket socket;
        private final AtomicBoolean queueFull = new AtomicBoolean();

        LogSender(Socket socket) throws SocketException {
            this.socket = socket;
            socket.setKeepAlive(true);
            socket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(10L));
        }

        void postLog(LogMessage log) {
            boolean posted = this.logsToSend.offer(log);
            if (!posted) {
                this.queueFull.set(true);
                LOGGER2.warn("queue full, dropping remote log of statement");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<LoggingConnectionInvocationHandler, ConnectionInfo> map = connectionToInfo;
            synchronized (map) {
                for (ConnectionInfo connectionInfo : connectionToInfo.values()) {
                    this.logsToSend.offer(connectionInfo);
                }
            }
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(this.socket.getOutputStream());
                int cnt = 0;
                try {
                    while (true) {
                        LogMessage log;
                        if (this.queueFull.compareAndSet(true, false)) {
                            oos.writeUnshared(new BufferFullLogMessage(System.currentTimeMillis()));
                        }
                        if ((log = this.logsToSend.poll(10L, TimeUnit.SECONDS)) != null) {
                            oos.writeUnshared(log);
                        } else {
                            if (this.socket.isClosed()) break;
                            if (!this.socket.isConnected()) {
                                break;
                            }
                            oos.writeUnshared(null);
                        }
                        if ((cnt = (cnt + 1) % 10) != 0) continue;
                        oos.reset();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                LOGGER2.warn("socket error", e);
            }
            finally {
                LOGGER2.info("closing connection with " + this.socket);
                senders.remove(this);
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ignored) {}
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOGGER2.error("error while closing socket", e);
                }
            }
        }
    }
}

