/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.DriverConfig;
import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.driver.LoggingConnectionInvocationHandler;
import ch.sla.jdbcperflogger.driver.Utils;
import ch.sla.jdbcperflogger.logger.PerfLoggerRemoting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class WrappingDriver
implements Driver {
    public static final String URL_PREFIX = "jdbcperflogger:";
    private static final Logger LOGGER = Logger.getLogger(WrappingDriver.class);
    private static final WrappingDriver INSTANCE = new WrappingDriver();
    private static final Map<String, Driver> underlyingDrivers = new ConcurrentHashMap<String, Driver>();
    private static boolean registered;
    private static final AtomicInteger connectionCounter;

    public static synchronized Driver load() {
        if (!registered) {
            try {
                DriverManager.registerDriver(INSTANCE);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            registered = true;
        }
        return INSTANCE;
    }

    public static synchronized void unload() {
        if (registered) {
            try {
                DriverManager.deregisterDriver(INSTANCE);
                registered = false;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Nullable
    public Connection connect(@Nullable String url, @Nullable Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        assert (url != null);
        LOGGER.debug("connect url=[" + url + "]");
        String unWrappedUrl = this.extractUrlForWrappedDriver(url);
        Driver underlyingDriver = null;
        String underlyingDriverClassName = DriverConfig.INSTANCE.getClassNameForJdbcUrl(unWrappedUrl);
        if (underlyingDriverClassName != null) {
            underlyingDriver = underlyingDrivers.get(underlyingDriverClassName);
        }
        if (underlyingDriver == null && underlyingDriverClassName != null) {
            try {
                Class<?> underlyingDriverClass = Class.forName(underlyingDriverClassName);
                underlyingDriver = (Driver)underlyingDriverClass.newInstance();
                underlyingDrivers.put(underlyingDriverClassName, underlyingDriver);
            }
            catch (ClassNotFoundException e) {
                String msg = MessageFormat.format("Cannot find driver class {0} for JDBC url {1}", underlyingDriverClassName, unWrappedUrl);
                LOGGER.warn(msg, e);
            }
            catch (InstantiationException e) {
                throw new SQLException(e);
            }
            catch (IllegalAccessException e) {
                throw new SQLException(e);
            }
        }
        if (underlyingDriver == null) {
            underlyingDriver = DriverManager.getDriver(unWrappedUrl);
        }
        long startNanos = System.nanoTime();
        Connection connection = underlyingDriver.connect(unWrappedUrl, info);
        long connectionCreationDuration = System.nanoTime() - startNanos;
        Properties cleanedConnectionProperties = new Properties();
        if (info != null) {
            for (String str : info.stringPropertyNames()) {
                if (str.toLowerCase().contains("password")) continue;
                cleanedConnectionProperties.setProperty(str, info.getProperty(str));
            }
        }
        LoggingConnectionInvocationHandler connectionInvocationHandler = new LoggingConnectionInvocationHandler(connectionCounter.incrementAndGet(), connection, unWrappedUrl, cleanedConnectionProperties);
        connection = (Connection)Proxy.newProxyInstance(WrappingDriver.class.getClassLoader(), Utils.extractAllInterfaces(connection.getClass()), (InvocationHandler)connectionInvocationHandler);
        PerfLoggerRemoting.connectionCreated(connectionInvocationHandler, connectionCreationDuration);
        return connection;
    }

    @Override
    public boolean acceptsURL(@Nullable String url) throws SQLException {
        return url != null && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(@Nullable String url, @Nullable Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private String extractUrlForWrappedDriver(String url) {
        return url.substring(URL_PREFIX.length());
    }

    static {
        WrappingDriver.load();
        connectionCounter = new AtomicInteger();
    }
}

