/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.DatabaseType;
import ch.sla.jdbcperflogger.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nullable;

public final class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class);

    private Utils() {
    }

    static DatabaseType getDatabaseType(Connection connection) {
        String dbProduct;
        try {
            dbProduct = connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            LOGGER.error("cannot get db product name");
            return DatabaseType.GENERIC;
        }
        if ("Oracle".equals(dbProduct)) {
            return DatabaseType.ORACLE;
        }
        return DatabaseType.GENERIC;
    }

    @Nullable
    static Object invokeUnwrapException(Object target, Method method, @Nullable Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static Object invokeUnwrapExceptionReturnNonNull(Object target, Method method, @Nullable Object[] args) throws Throwable {
        try {
            Object result = method.invoke(target, args);
            assert (result != null);
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static Class<?>[] extractAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        for (Class<?> currClazz = clazz; currClazz != null; currClazz = currClazz.getSuperclass()) {
            Collections.addAll(interfaces, currClazz.getInterfaces());
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }
}

