/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.DatabaseType;
import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.StatementType;
import ch.sla.jdbcperflogger.driver.LoggingResultSetInvocationHandler;
import ch.sla.jdbcperflogger.driver.LoggingStatementInvocationHandler;
import ch.sla.jdbcperflogger.driver.Utils;
import ch.sla.jdbcperflogger.logger.PerfLogger;
import ch.sla.jdbcperflogger.model.PreparedStatementValuesHolder;
import ch.sla.jdbcperflogger.model.SqlTypedValue;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public class LoggingPreparedStatementInvocationHandler
extends LoggingStatementInvocationHandler {
    private static final String JAVA_SQL_SQL_TYPE = "java.sql.SQLType";
    private static final String CLEAR_PARAMETERS = "clearParameters";
    private static final Logger LOGGER = Logger.getLogger(LoggingPreparedStatementInvocationHandler.class);
    @Nullable
    private static final Method getVendorTypeNumberMethod;
    private final String rawSql;
    private final PreparedStatementValuesHolder paramValues = new PreparedStatementValuesHolder();
    private final List<Object> batchedPreparedOrNonPreparedStmtExecutions = new ArrayList<Object>();

    LoggingPreparedStatementInvocationHandler(UUID connectionId, PreparedStatement statement, String rawSql, DatabaseType databaseType) {
        super(connectionId, statement, databaseType);
        this.rawSql = rawSql;
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object proxy, @Nullable Method _method, @Nullable Object[] args) throws Throwable {
        assert (_method != null);
        Method method = _method;
        String methodName = method.getName();
        if (args == null || args.length == 0) {
            if ("executeQuery".equals(methodName) && args == null) {
                return this.internalExecutePreparedQuery(method);
            }
            if ("execute".equals(methodName) || "executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName)) {
                return this.internalExecutePrepared(method, args);
            }
            if ("addBatch".equals(methodName)) {
                Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
                this.batchedPreparedOrNonPreparedStmtExecutions.add(this.paramValues.copy());
                return result;
            }
            if ("clearBatch".equals(methodName)) {
                Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
                this.batchedPreparedOrNonPreparedStmtExecutions.clear();
                return result;
            }
            if (CLEAR_PARAMETERS.equals(methodName)) {
                Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
                this.paramValues.clear();
                return result;
            }
        } else if (methodName.startsWith("set")) {
            Class<?>[] argType;
            Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
            if ("setNull".equals(methodName) && args[1] instanceof Integer) {
                this.paramValues.put((Serializable)args[0], new SqlTypedValue(null, (Integer)args[1]));
            } else if (args.length == 2 || "setDate".equals(methodName) || "setTime".equals(methodName) || "setTimestamp".equals(methodName)) {
                this.paramValues.put((Serializable)args[0], new SqlTypedValue(args[1], methodName));
            } else if ("setObject".equals(methodName) && (argType = method.getParameterTypes()).length > 2) {
                Integer sqlType = null;
                if (argType[2] == Integer.TYPE) {
                    sqlType = (Integer)args[2];
                } else if (getVendorTypeNumberMethod != null && argType[2].getName().equals(JAVA_SQL_SQL_TYPE) && args[2] != null) {
                    Method tempMethod = getVendorTypeNumberMethod;
                    sqlType = (Integer)tempMethod.invoke(args[2], new Object[0]);
                }
                this.paramValues.put((Serializable)args[0], new SqlTypedValue(args[1], sqlType));
            }
            return result;
        }
        return super.invoke(proxy, method, args);
    }

    protected ResultSet internalExecutePreparedQuery(Method method) throws Throwable {
        UUID logId = UUID.randomUUID();
        PerfLogger.logBeforePreparedStatement(this.connectionId, logId, this.rawSql, this.paramValues, StatementType.PREPARED_QUERY_STMT, this.databaseType, this.wrappedStatement.getQueryTimeout(), this.wrappedStatement.getConnection().getAutoCommit());
        long start = System.nanoTime();
        Throwable exc = null;
        try {
            ResultSet resultSet = (ResultSet)Utils.invokeUnwrapExceptionReturnNonNull(this.wrappedStatement, method, null);
            ResultSet resultSet2 = (ResultSet)Proxy.newProxyInstance(LoggingPreparedStatementInvocationHandler.class.getClassLoader(), Utils.extractAllInterfaces(resultSet.getClass()), (InvocationHandler)new LoggingResultSetInvocationHandler(resultSet, logId));
            return resultSet2;
        }
        catch (Throwable e) {
            exc = e;
            throw exc;
        }
        finally {
            long end = System.nanoTime();
            PerfLogger.logStatementExecuted(logId, end - start, null, exc);
        }
    }

    @Nullable
    protected Object internalExecutePrepared(Method method, @Nullable Object[] args) throws Throwable {
        Object object;
        UUID logId = UUID.randomUUID();
        long start = System.nanoTime();
        PerfLogger.logBeforePreparedStatement(this.connectionId, logId, this.rawSql, this.paramValues, StatementType.BASE_PREPARED_STMT, this.databaseType, this.wrappedStatement.getQueryTimeout(), this.wrappedStatement.getConnection().getAutoCommit());
        Throwable exc = null;
        Long updateCount = null;
        try {
            Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
            if (result instanceof Number) {
                updateCount = ((Number)result).longValue();
            }
            object = result;
        }
        catch (Throwable e) {
            try {
                exc = e;
                throw exc;
            }
            catch (Throwable throwable) {
                long end = System.nanoTime();
                PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
                throw throwable;
            }
        }
        long end = System.nanoTime();
        PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object internalExecuteBatch(Method method, @Nullable Object[] args) throws Throwable {
        UUID logId = UUID.randomUUID();
        PerfLogger.logPreparedBatchedStatements(this.connectionId, logId, this.rawSql, this.batchedPreparedOrNonPreparedStmtExecutions, this.databaseType, this.wrappedStatement.getQueryTimeout(), this.wrappedStatement.getConnection().getAutoCommit());
        try {
            Object object = this.internalExecuteBatchInternal(method, args, logId);
            return object;
        }
        finally {
            this.batchedPreparedOrNonPreparedStmtExecutions.clear();
        }
    }

    static {
        Method tempMethod = null;
        try {
            Class<?> sqlTypeClass = Class.forName(JAVA_SQL_SQL_TYPE);
            tempMethod = sqlTypeClass.getMethod("getVendorTypeNumber", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("not running under java 8");
        }
        catch (SecurityException e) {
            LOGGER.warn("Error getting getVendorTypeNumber method from java.sql.SQLType");
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("Error getting getVendorTypeNumber method from java.sql.SQLType");
        }
        finally {
            getVendorTypeNumberMethod = tempMethod;
        }
    }
}

