package com.proximities.sdk.json.model.appointments;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.Keep;

@Keep
public class IpsTrigger implements Parcelable {

    private int id;
    private String idMapping;
    private String ipsId;
    private String type;
    private double latitude;
    private double longitude;
    private double displayLatitude;
    private double displayLongitude;
    private String level;

    protected IpsTrigger(Parcel in) {
        id = in.readInt();
        idMapping = in.readString();
        ipsId = in.readString();
        type = in.readString();
        latitude = in.readDouble();
        longitude = in.readDouble();
        displayLatitude = in.readDouble();
        displayLongitude = in.readDouble();
        level = in.readString();
    }

    public static final Creator<IpsTrigger> CREATOR = new Creator<IpsTrigger>() {
        @Override
        public IpsTrigger createFromParcel(Parcel in) {
            return new IpsTrigger(in);
        }

        @Override
        public IpsTrigger[] newArray(int size) {
            return new IpsTrigger[size];
        }
    };

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getIdMapping() {
        return idMapping;
    }

    public void setIdMapping(String idMapping) {
        this.idMapping = idMapping;
    }

    public String getIpsId() {
        return ipsId;
    }

    public void setIpsId(String ipsId) {
        this.ipsId = ipsId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getDisplayLatitude() {
        return displayLatitude;
    }

    public void setDisplayLatitude(double displayLatitude) {
        this.displayLatitude = displayLatitude;
    }

    public double getDisplayLongitude() {
        return displayLongitude;
    }

    public void setDisplayLongitude(double displayLongitude) {
        this.displayLongitude = displayLongitude;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(id);
        parcel.writeString(idMapping);
        parcel.writeString(ipsId);
        parcel.writeString(type);
        parcel.writeDouble(latitude);
        parcel.writeDouble(longitude);
        parcel.writeDouble(displayLatitude);
        parcel.writeDouble(displayLongitude);
        parcel.writeString(level);
    }
}
