package com.proximities.sdk;

import android.Manifest;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;

import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.proximities.sdk.util.LogUtils;
import com.proximities.sdk.util.ProximitiesConstants;

import java.lang.ref.WeakReference;
import java.util.Random;

public class GeofenceBroadcastReceiver extends BroadcastReceiver {

    private static final String WORK_TAG = "prxsc_geofence_worker";

    @Override
    public void onReceive(Context context, Intent intent) {
        if(intent.getIntExtra(ProximitiesConstants.EXTRA_KEY_GEOFENCING_RECEIVER, -1) == ProximitiesConstants.EXTRA_FROM_GEOFENCING_EVENT){
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent(intent);
            if(geofencingEvent == null || geofencingEvent.hasError()) {
                Log.e("WTF", "Geofencing error code :" + geofencingEvent.getErrorCode());
                return;
            }

            int geofenceTransition = geofencingEvent.getGeofenceTransition();
            if (geofenceTransition == Geofence.GEOFENCE_TRANSITION_ENTER){
                if(!ProximitiesSystem.getInstance().isAppInForeground()){
                    OneTimeWorkRequest request = new OneTimeWorkRequest.Builder(ProximitiesWorker.class).build();
                    WorkManager.getInstance(context).enqueueUniqueWork(WORK_TAG, ExistingWorkPolicy.REPLACE, request);
                }
            } else if(geofenceTransition == Geofence.GEOFENCE_TRANSITION_EXIT){
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && ProximitiesPrefs.readForegroundServiceEnabled(context)){
//                    Intent intentService = new Intent(context, ProximitiesBeaconService.class);
//                    intentService.putExtra("action", ProximitiesConstants.BEACON_STOP_FOREGROUND_SERVICE);
//                    context.startForegroundService(intentService);
//                }
            }
        }


    }
}
