package com.proximities.sdk.request.api;

import android.content.Context;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.interfaces.LoyaltyInterface;
import com.proximities.sdk.json.model.loyalty.BaseLoyalty;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.LogUtils;

import java.util.Map;

import static com.proximities.sdk.util.LogUtils.LOGD;

/**
 * Created by william on 23/02/16.
 */
public class LoyaltyRequest implements Response.Listener<BaseLoyalty>, Response.ErrorListener {

    private static final String TAG = LogUtils.makeLogTag(LoyaltyRequest.class);
    private Context ctx;
    private String wsLoyalty;
    private LoyaltyInterface mCallback;

    public LoyaltyRequest(Context ctx, LoyaltyInterface callback) {
        this.ctx = ctx;
        this.mCallback = callback;
        wsLoyalty = BuildConfig.HOST + ctx.getString(R.string.prxsc_ws_loyalty);
    }

    public void executePost(int animId) {
        String url = wsLoyalty + "/" + animId + "/refresh";
        LOGD(TAG, "POST : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(ctx, "POST&" + url);
        GsonRequest<BaseLoyalty> request = new GsonRequest(
                Request.Method.POST,
                url,
                BaseLoyalty.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(BaseLoyalty baseLoyalty) {
        if(mCallback != null){
            mCallback.onRefreshLoyaltySuccess(baseLoyalty.getData().getCampaigns().get(0));
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if(mCallback != null) mCallback.onRefreshLoyaltyError();
    }
}
