package com.proximities.sdk.request.api;

import android.content.Context;

import com.proximities.sdk.corekit.CoreKitInstance;
import com.proximities.sdk.BuildConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.interfaces.FavoriteActionsInterface;
import com.proximities.sdk.interfaces.GetFavoritesInterface;
import com.proximities.sdk.json.WsHeader;
import com.proximities.sdk.json.model.animation.AnimationData;
import com.proximities.sdk.json.model.partner.BasePartner;
import com.proximities.sdk.request.GsonRequest;
import com.proximities.sdk.request.Header;
import com.proximities.sdk.util.LogUtils;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import java.util.Map;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 04/01/15.
 */
public final class AnimationRequest implements Response.Listener<WsHeader>, Response.ErrorListener {

    private static final String TAG = LogUtils.makeLogTag(AnimationRequest.class);

    private static int methodHttp;
    private Context context;
    private String wsAnim;
    private GetFavoritesInterface mGetCallback;
    private FavoriteActionsInterface mActionsCallback;

    public AnimationRequest(Context context, GetFavoritesInterface getCallback) {
        this.context = context;
        this.mGetCallback = getCallback;
        wsAnim = BuildConfig.HOST + context.getString(R.string.prxsc_ws_favorites);
    }

    public AnimationRequest(Context context, FavoriteActionsInterface actionsCallback){
        this.context = context;
        this.mActionsCallback = actionsCallback;
        wsAnim = BuildConfig.HOST + context.getString(R.string.prxsc_ws_favorites);
    }

    public void executePost(int animationId) {
        methodHttp = Request.Method.POST;
        String url = wsAnim + "/" + animationId + "/archive";
        LogUtils.LOGD(TAG, "POST : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "POST&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.POST,
                url,
                WsHeader.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    public void executeGet() {
        methodHttp = Request.Method.GET;
        LogUtils.LOGD(TAG, "GET : " + wsAnim);
        Map<String, String> params = Header.getInstance().makeHeader(context, "GET&" + wsAnim);
        GsonRequest<AnimationData> request = new GsonRequest(
                Request.Method.GET,
                wsAnim,
                AnimationData.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    public void executeDel(int animationId) {
        methodHttp = Request.Method.DELETE;
        String url = wsAnim + "/" + animationId;
        LogUtils.LOGD(TAG, "DELETE : " + url);
        Map<String, String> params = Header.getInstance().makeHeader(context, "DELETE&" + url);
        GsonRequest<BasePartner> request = new GsonRequest(
                Request.Method.DELETE,
                url,
                WsHeader.class,
                params,
                this,
                this);
        CoreKitInstance.getSharedInstance().getRequestQueue().add(request);
    }

    @Override
    public void onResponse(WsHeader wsHeader) {
        if (methodHttp == Request.Method.GET && wsHeader != null && mGetCallback != null) {
            mGetCallback.onGetFavorites(((AnimationData) wsHeader).getData().getCampaigns());
        } else if (methodHttp == Request.Method.POST && mActionsCallback != null) {
            mActionsCallback.onAddCampaignToFavorites();
        } else if (methodHttp == Request.Method.DELETE && mActionsCallback != null) {
            mActionsCallback.onDeleteCampaignFromFavorites();
        }
    }

    @Override
    public void onErrorResponse(VolleyError volleyError) {
        if (methodHttp == Request.Method.GET && mGetCallback != null) {
            mGetCallback.onGetFavoritesError();
        } else if (methodHttp == Request.Method.POST && mActionsCallback != null) {
            mActionsCallback.onAddCampaignError();
        } else if (methodHttp == Request.Method.DELETE && mActionsCallback != null) {
            mActionsCallback.onDeleteCampaignError();
        }
    }
}
