package com.proximities.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;

import com.proximities.sdk.ProximitiesConfig;

import com.proximities.sdk.R;

import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 19/11/14.
 */
public abstract class Utils {

    public static String getCurrentLanguage(Context ctx) {
        return ctx.getResources().getConfiguration().locale.getLanguage();
    }

    public static String getAppId(Context ctx) {
        return getMetaData(ctx).getString("proximities:appId");
    }

    public static String getAppSecret(Context ctx) {
        return getMetaData(ctx).getString("proximities:appSecret");
    }

    /**
     * Get application meta-data of a package name.
     *
     * @param context application context.
     * @return meta-data, may be empty but never null.
     */
    public static Bundle getMetaData(Context context) {
        Bundle config;
        try {
            config = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA).metaData;
            if (config == null) {
                config = new Bundle();
            }
        } catch (Exception e) {
            /*
             * NameNotFoundException or in some rare scenario an undocumented "RuntimeException: Package
             * manager has died.", probably caused by a system app process crash.
             */
            config = new Bundle();
        }
        return config;
    }

    public static boolean isColorDark(int color){
        double darkness = 1-(0.299* Color.red(color) + 0.587*Color.green(color) + 0.114*Color.blue(color))/255;
        return darkness >= 0.1;
    }

    public static void endCampaignDisplay(Activity activity, boolean isMultiCampaign){
        Intent intent = null;
        try {
            if(ProximitiesConfig.getInstance() != null && ProximitiesConfig.getInstance().isUsingCurrentActivity()){
                intent = new Intent(activity.getApplicationContext(), Class.forName(ProximitiesConfig.getInstance().getCurrentActivity()));
                intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
            } else {
                intent = new Intent(activity.getApplicationContext(), Class.forName(ProximitiesConfig.getMainActivity(activity.getApplicationContext())));
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if(intent != null){
            activity.startActivity(intent);
        }
        activity.finish();
        if(!isMultiCampaign){
            activity.overridePendingTransition(R.anim.null_animation, R.anim.zoom_out);
        }
    }

    public static String getCurrentDate(){
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(calendar.getTime());
    }
}
